/* korb-broker.cc */
/* Created by Enomoto Sanshiro on 13 February 2000. */
/* Last updated by Enomoto Sanshiro on 5 March 2000. */


#include <cstdlib>
#include <iostream>
#include "MushArgumentList.hh"
#include "MushMisc.hh"
#include "KorbBroker.hh"

using namespace std;


int main(int argc, char **argv)
{
    TMushArgumentList ArgumentList(argc, argv);
#if 0
    ArgumentList.Dump(cerr);
#endif

    TKorbBroker* Broker = 0;
    if (ArgumentList.NumberOfParameters() <= 1) {
	string LaunchPathList = ArgumentList.ParameterOf(0);
	Broker = new TKorbBroker(LaunchPathList);
    }
    else {
	try {
	    int DomainId = ArgumentList.IntParameterOf(0);
	    int ParentDomainId = ArgumentList.IntParameterOf(1);
	    string ParentHostName = ArgumentList.ParameterOf(2);
	    int ParentPortNumber = ArgumentList.IntParameterOf(3);
	    string WorkingDirectory = ArgumentList.ParameterOf(4);
	    string LaunchPathList = ArgumentList.ParameterOf(5);

	    Broker = new TKorbBroker(
		DomainId, 
		ParentDomainId, ParentHostName, ParentPortNumber, 
		WorkingDirectory, LaunchPathList
	    );
	}
	catch (TSystemCallException &e) {
	    cerr << "ERROR: " << argv[0] << ": bad arguments" << endl;
	    exit(EXIT_FAILURE);
	}
    }

    try {
	Broker->Start();
    }
    catch (TKorbException& e) {
      cerr << "ERROR: " << argv[0] << "@" << TMushLocalHost::HostName() << ": " << e << endl;
    }

    delete Broker;

    return 0;
}
