/* LogBookOrb.hh */
/* Created by Enomoto Sanshiro on 23 February 2000. */
/* Last updated by Enomoto Sanshiro on 23 February 2000. */


#include <string>
#include "KorbOrb.hh"
#include "KorbObjectAdapter.hh"
#include "KorbObjectProxy.hh"
#include "KorbObjectMessenger.hh"
#include "LogBook.hh"


class TLogBookProxy: public TKorbObjectProxy, public TLogBook {
  public:
    TLogBookProxy(TKorbOrb* Orb);
    virtual ~TLogBookProxy();
    virtual int Write(long Date, std::string Name, std::string Contents);
};



class TLogBookMessenger: public TKorbObjectMessenger {
  public:
    enum TMethodId {
	MethodId_Write
    };
  public:
    TLogBookMessenger(TLogBook* LogBook);
    virtual ~TLogBookMessenger();
    virtual int DispatchMethodInvocation(TKorbOrbPacket& OrbPacket) throw(TKorbException);
  protected:
    TLogBook* _LogBook;
};
