/* KumaDefs.hh */
/* Created by Enomoto Sanshiro on 11 October 2003. */
/* Last updated by Enomoto Sanshiro on 11 October 2003. */


#ifndef __KumaDefs_hh__
#define __KumaDefs_hh__


#include <iostream>
#include <string>
#include <cstring>


namespace kuma {


class TKumaException {
  public:
    TKumaException(std::string Message);
    TKumaException(std::string Location, std::string Message);
    TKumaException(const TKumaException &e);
    std::string Message(void) const;
    friend std::ostream& operator<< (std::ostream &os, const TKumaException &e);
  protected:
    std::string _Message;
};


template <class T> inline T sqr(const T& x) {return x * x;}
template <class T> inline T cube(const T& x) {return x * x * x;}

template<class T> inline int sign(const T& x) { return (x>=0) ? +1: -1; }


}

#endif
