/* KumaFourierTransform.cc */
/* Created by Enomoto Sanshiro on 19 October 2003. */
/* Last updated by Enomoto Sanshiro on 21 October 2003. */


#include <complex>
#include <cmath>
#include <algorithm>
#include "KumaDefs.hh"
#include "KumaFourierTransform.hh"


using namespace std;
using namespace kuma;



TKumaFastFourierTransformer::TKumaFastFourierTransformer(void)
{
}

TKumaFastFourierTransformer::~TKumaFastFourierTransformer()
{
}

void TKumaFastFourierTransformer::Transform(complex<double>* DataList, int ListSize, int Sign) throw(TKumaException)
{
    // data length check //
    int n = 1, m = 0;
    while (n < ListSize) {
	n <<= 1;
	m++;
    }
    if (n != ListSize) {
	throw TKumaException(
	    "TKumaFastFourierTransformer::Transform()",
	    "invalid data list size"
	);
    }

    // sort into bit-reversal order //
    for (int i = 0; i < n; i++) {
	int j = 0;
	for (int k0 = 1, k1 = n>>1; (k0 <= i) && (j < i); k0 <<= 1, k1 >>= 1) {
	    if (i & k0) {
		j |= k1;
	    }
	}
	if (j < i) {
	    swap(DataList[i], DataList[j]);
	}
    }

    for (int Step = 1; Step < n; Step *= 2) {
	double Theta = Sign * (2*M_PI / (2*Step));
	complex<double> UnitW(cos(Theta), sin(Theta));
	complex<double> W(1, 0);

	for (int k = 0; k < Step; k++) {
	    for (int i = k; i < n; i += 2*Step) {
		int j = i + Step;
		complex<double> W_DataListJ = W * DataList[j];
		DataList[j] = DataList[i] - W_DataListJ;
		DataList[i] = DataList[i] + W_DataListJ;
	    }
	    W *= UnitW;
	}
    }
}
