/* KumaFourierTransform.hh */
/* Created by Enomoto Sanshiro on 19 October 2003. */
/* Last updated by Enomoto Sanshiro on 19 October 2003. */


// TKumaFastFourierTransformer::Transform() $B$O9bB.%U!<%j%(JQ49$r9T$J$&!%(B
// DataList $B$r%U!<%j%(JQ49$7!$7k2L$rF1$8G[Ns$K$b$I$9!%(B
// DataListSize ($B0J2<(B n $B$H$9$k(B) $B$O(B 2 $B$N@0?t>h(B (n = 2**m) $B$G$J$1$l$P$P$i$J$$!%(B
// $B5UJQ49$r9T$J$&$K$O!$(BSign $B$K(B -1 $B$rEO$7!$7k2L$K(B 1/n $B$r3]$1$k!%(B
// 
// h(t) :--> H(f) $B$HJQ49$9$k$H$9$k$H!$(Bt $B$N4V3V(B dt $B$KBP$7$F7h$^$k(B
// $B<~GH?t(B fc = 0.5/dt (Nyquist critical frequency: $B%J%$%-%9%HNW3&<~GH?t(B)
// $B$^$G$N<~GH?tHO0O(B [-fc..fc] $B$rJQ497k2L$KJV$9!%%9%F%C%WI}$O(B df = fc/(n/2)$B!%(B
// Data[0..n/2] $B$K(B { H(f) | f = [0..fc] } $B$,!$(B
// Data[n/2..n-1] $B$K(B { H(f) | f = [-fc..-df] } $B$,!$(B
// $B$=$l$>$l3JG<$5$l$k!%(BH(fc) $B$O(B H(-fc) $B$HEy$7$/!$(BData[n/2] $B$K3JG<$5$l$k!%(B
// 
// H(fc) $B$,(B 0 $B$G$J$1$l$P(B(f --> fc $B$G(B H(f) --> 0 $B$G$J$1$l$P(B)$B!$JQ497k2L$K$O(B
// $B%5%s%W%j%s%0$K$h$j@Z$j<N$F$i$l$?<~GH?tBS(B f>fc $B$N@^$jJV$7;(2;(B($B%(%$%j%"%7%s%0(B) 
// $B$,4^$^$l$F$$$k$3$H$K$J$k!%(B
// ($B@^$jJV$7$,5/$-$F$$$F$b(B H(fc)==0 $B$K$J$k$3$H$b$"$k(B)


#ifndef __KumaFourierTransform_hh__
#define __KumaFourierTransform_hh__

#include <complex>
#include "KumaDefs.hh"


namespace kuma {


class TKumaFastFourierTransformer {
  public:
    TKumaFastFourierTransformer(void);
    virtual ~TKumaFastFourierTransformer();
    virtual void Transform(std::complex<double>* DataList, int ListSize, int Sign = +1) throw(TKumaException);
};


}

#endif
