// KumaUnits.hh
// Created by Enomoto Sanshiro on 26 August 1998.
// Last updated by Enomoto Sanshiro on 14 February 2003.


#ifndef __KumaUnits_hh
#define __KumaUnits_hh

namespace kuma {


static const double  ppm = 1.0e-6;
static const double  ppb = 1.0e-9;
static const double  ppt = 1.0e-12;
static const double  eV = 1.0;
static const double  eV2 = eV * eV;
static const double  keV = 1.0e+3 * eV;
static const double  MeV = 1.0e+6 * eV;
static const double  GeV = 1.0e+9 * eV;
static const double  TeV = 1.0e+12 * eV;
static const double  Jule = (1 / 1.60217733e-19) * eV;
static const double  erg = 1.0e-7 * Jule;
static const double  AU = 931.494013 * MeV;
static const double  m = 1.0;
static const double  m2 = m * m;
static const double  m3 = m * m * m;
static const double  mm = 1.0e-3 * m;
static const double  mm2 = mm * mm;
static const double  mm3 = mm * mm * mm;
static const double  cm = 1.0e-2 * m;
static const double  cm2 = cm * cm;
static const double  cm3 = cm * cm * cm;
static const double  km = 1.0e+3 * m;
static const double  km2 = km * km;
static const double  km3 = km * km * km;
static const double  inch = 2.54 * cm;
static const double  fm = 1.0e-15 * m;
static const double  fm2 = fm * fm;
static const double  fm3 = fm * fm * fm;
static const double  au = 1.49597870e+11 * m;
static const double  pc = 3.0856776e+16 * m;
static const double  kg = 1.0;
static const double  g = 1.0e-3 * kg;
static const double  mg = 1.0e-6 * kg;
static const double  ton = 1.0e+3 * kg;
static const double  kton = 1.0e+3 * ton;
static const double  sec = 1.0;
static const double  minute = 60 * sec;
static const double  hour = 60 * minute;
static const double  day = 86400.0 * sec;
static const double  year = 31556925.2 * sec;
static const double  msec = 1.0e-3 * sec;
static const double  usec = 1.0e-6 * sec;
static const double  nsec = 1.0e-9 * sec;
static const double  psec = 1.0e-12 * sec;
static const double  mole = 6.0221367e+23;
static const double  barn = 100.0 * fm * fm;
static const double  mbarn = 1.0e-3 * barn;
static const double  rad = 1.0;
static const double  deg = 3.1415926535897932384 / 180.0;
static const double  Bq = 1.0;
static const double  kBq = 1.0e+3 * Bq;
static const double  MBq = 1.0e+6 * Bq;
static const double  Hz = 1.0 * (1/sec);
static const double  kHz = 1.0e+3 * Hz;
static const double  MHz = 1.0e+6 * Hz;
static const double  C = 1.0;
static const double  pC = 1.0e-12 * C;

}

#endif
