/* MushArgumentList.hh */
/* Created by Enomoto Sanshiro on 8 July 2000. */
/* Last updated by Enomoto Sanshiro on 8 July 2000. */


#ifndef __MushArgumentList_hh__
#define __MushArgumentList_hh__


#include <iostream>
#include <string>
#include <deque>
#include <map>
#include <set>
#include "MushDefs.hh"


class TMushArgumentList {
  public:
    TMushArgumentList(int argc, char** argv);
    virtual ~TMushArgumentList();
    virtual const std::string& ProgramName(void) const;
    virtual const std::deque<std::string>& ParameterList(void) const;
    virtual const std::set<char>& SwitchSet(void) const;
    virtual const std::map<std::string, std::string>& OptionTable(void) const;
  public:
    virtual int NumberOfParameters(void) const;
    virtual void ExpectParameters(int NumberOfExpectedParameters) const throw(TSystemCallException);
    virtual std::string ParameterOf(int Index) const;
    virtual std::string operator[] (int Index) const;
    virtual long IntParameterOf(int Index) const throw(TSystemCallException);
    virtual double FloatParameterOf(int Index) const throw(TSystemCallException);
  public:
    virtual bool IsSwitchSpecified(char SwitchCharacter) const;
  public:
    virtual bool IsOptionSpecified(const std::string& OptionName, char EquivalentSwitchCharacter = '\0') const;
    virtual std::string OptionValueOf(const std::string& Name, const std::string& DefaultValue = "") const;
    virtual std::string operator[] (const std::string& Name) const;
    virtual long IntOptionValueOf(const std::string& Name) const throw(TSystemCallException);
    virtual long IntOptionValueOf(const std::string& Name, long DefaultValue) const throw(TSystemCallException);
    virtual double FloatOptionValueOf(const std::string& Name) const throw(TSystemCallException);
    virtual double FloatOptionValueOf(const std::string& Name, double DefaultValue) const throw(TSystemCallException);
  public:
    virtual std::string RemoveParameter(int Index = 0, int Count = 1);
    virtual void InsertParameter(const std::string& Parameter, int Index = -1);
    virtual std::string RemoveOption(const std::string& Name);
    virtual void AddOption(const std::string& Name, const std::string& Value = "");
    virtual void Dump(std::ostream& os) const;
  protected:
    virtual void Parse(void) const;
  protected:
    int _argc;
    char** _argv;
    mutable bool _IsParsed;
    mutable std::string _ProgramName;
    mutable std::deque<std::string> _ParameterList;
    mutable std::map<std::string, std::string> _OptionTable;
    mutable std::set<char> _SwitchSet;
};


#endif
