/* MushCFileStream.hh */
/* Created by Enomoto Sanshiro on 31 August 2003. */
/* Last updated by Enomoto Sanshiro on 31 August 2003. */


#ifndef __MushCFileStream_hh__
#define __MushCFileStream_hh__

#include <iostream>
#include <cstdio>



class TMushCFileStreamBuffer: public std::streambuf {
  public:
    TMushCFileStreamBuffer(std::FILE* CFile);
    virtual ~TMushCFileStreamBuffer();
  protected:
    virtual int overflow(int ch = EOF);
    virtual int underflow(void);
    virtual int sync(void);
  private:
    std::FILE* _CFile;
    char *_Buffer;
    int _BufferSize;
};


class TMushInputCFileStream: public std::istream {
  public:
    TMushInputCFileStream(std::FILE* CFile);
    virtual ~TMushInputCFileStream();
    virtual TMushCFileStreamBuffer* rdbuf(void);
  private:
    TMushCFileStreamBuffer* _StreamBuffer;
};


class TMushOutputCFileStream: public std::ostream {
  public:
    TMushOutputCFileStream(std::FILE* CFile);
    virtual ~TMushOutputCFileStream();
    virtual TMushCFileStreamBuffer* rdbuf(void);
  private:
    TMushCFileStreamBuffer* _StreamBuffer;
};


#endif
