/* MushConsole.hh */
/* Created by Enomoto Sanshiro on 29 November 2000. */
/* Last updated by Enomoto Sanshiro on 29 November 2000. */


#ifndef __MushConsole_hh__
#define __MushConsole_hh__


#include <string>
#include "MushDefs.hh"


class TMushConsole {
  public:
    TMushConsole(void);
    virtual ~TMushConsole();
    virtual std::string SetPrompt(const std::string& Prompt);
    virtual bool GetLine(std::string& Line);
    virtual bool GetLineTo(char* Buffer, size_t MaxSize);
    virtual void Put(const char* Buffer, size_t Size);
  public:
    virtual void AddHistory(const std::string& Line);
    virtual void LoadHistoryFrom(const std::string& FileName);
    virtual void SaveHistoryTo(const std::string& FileName);
  protected:
    char* _Prompt;
    int _HistoryItemListCapacity, _NumberOfHistoryItems;
    std::string* _HistoryItemList;
    std::string _LastHistoryItem;
};


class TMushReadlineConsole: public TMushConsole {
  public:
    TMushReadlineConsole(void);
    virtual ~TMushReadlineConsole();
    virtual bool GetLine(std::string& Line);
    virtual bool GetLineTo(char* Buffer, size_t MaxSize);
    virtual void AddHistory(const std::string& Line);
};


#endif
