/* MushDecoratedFile.hh */
/* Created by Enomoto Sanshiro on 25 October 1999. */
/* Last updated by Enomoto Sanshiro on 30 April 2002. */


#ifndef __MushDecoratedFile_hh__
#define __MushDecoratedFile_hh__

#include <string>
#include "MushFile.hh"
#include "MushDataEncoder.hh"
#include "MushDataCompressor.hh"


class TMushDecoratedFile: public TMushFile {
  public:
    TMushDecoratedFile(TMushFile *ComponentFile);
    virtual ~TMushDecoratedFile();
    virtual void OpenReadMode(void) throw(TSystemCallException);
    virtual void OpenWriteMode(unsigned AccessMode = 0644, bool IsExclusive = false) throw(TSystemCallException);
    virtual void OpenAppendMode(unsigned AccessMode = 0644) throw(TSystemCallException);
    virtual void OpenReadWriteMode(unsigned AccessMode = 0644) throw(TSystemCallException);
    virtual void Close(void);
    virtual int Read(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual int Write(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual mush::Int64 Position(void) throw(TSystemCallException);
    virtual void SeekTo(mush::Int64 Offset) throw(TSystemCallException);
    virtual void SeekBy(mush::Int64 Offset) throw(TSystemCallException);
    virtual void Unlink(void) throw(TSystemCallException);
    virtual std::string Name(void) const;
    virtual long Size(void) const throw(TSystemCallException);
    virtual bool IsOpened(void) const;
    virtual int FileDescriptor(void) const;
  protected:
    TMushFile *_ComponentFile;
};



// The component file should be a instance of TMushFramedFile
// because fragmentation is critical.
// (note that the data size could be changed on the encoding process)
class TMushEncodedFile: public TMushDecoratedFile {
  public:
    TMushEncodedFile(TMushFile *ComponentFile, TMushDataEncoder* DataEncoder);
    virtual ~TMushEncodedFile();
    virtual int Read(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual int Write(void *Buffer, size_t Length) throw(TSystemCallException);
  protected:
    TMushDataEncoder* _DataEncoder;
    size_t _WorkAreaSize;
    char* _WorkArea;
};



class TMushCompressedFile: public TMushDecoratedFile {
  public:
    TMushCompressedFile(TMushFile *ComponentFile, TMushDataCompressor* DataCompressor = 0);
    virtual ~TMushCompressedFile();
    virtual void Close(void);
    virtual int Read(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual int Write(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual mush::Int64 Position(void) throw(TSystemCallException);
    virtual void SeekTo(mush::Int64 Offset) throw(TSystemCallException);
    virtual void SeekBy(mush::Int64 Offset) throw(TSystemCallException);
    virtual long Size(void) const throw(TSystemCallException);
  protected:
    TMushDataCompressor* _DataCompressor;
    char* _TargetBuffer;
    size_t _TargetBufferSize;
    bool _IsFirstRead;
    bool _IsOutputPending;
    bool _IsOwningCompressor;
};


#endif
