/* MushDefs.hh */
/* Created by Enomoto Sanshiro on 21 January 1998. */
/* Last updated by Enomoto Sanshiro on 18 February 1998. */


#ifndef __MushDefs_hh__
#define __MushDefs_hh__


#include <iostream>
#include <string>
#include <cstring>
#include "MushConfig.hh"


class TSystemCallException {
  protected:
    std::string _Message;
    int _ErrorNumber;
  public:
    TSystemCallException(std::string Location);
    TSystemCallException(std::string Location, int ErrorNumber);
    TSystemCallException(std::string Location, std::string Message);
    TSystemCallException(const TSystemCallException &e);
    friend std::ostream& operator<< (std::ostream &os, const TSystemCallException &e);
    int ErrorNumber(void) const;
    std::string Message(void) const;
    int operator== (int ErrorNumber) const;
};


#endif
