/* MushDomesticSocket.hh */
/* Created by Enomoto Sanshiro on 21 January 1998. */
/* Last updated by Enomoto Sanshiro on 19 November 1999. */


#ifndef __MushDomesticSocket_hh__
#define __MushDomesticSocket_hh__

#include <string>
#include "MushDefs.hh"
#include "MushSocket.hh"


class TMushDomesticSocket: virtual public TMushSocket {
  public:
    TMushDomesticSocket(std::string SocketPath);
    virtual ~TMushDomesticSocket();
    virtual std::string Path(void) const;
  protected:
    std::string _SocketPath;
};


class TMushServerDomesticSocket: public TMushServerSocket, public TMushDomesticSocket {
  public:
    TMushServerDomesticSocket(std::string SocketPath);
    virtual ~TMushServerDomesticSocket();
    virtual void Create(void) throw(TSystemCallException);
    virtual void Bind(void) throw(TSystemCallException);
    virtual void Accept(void) throw(TSystemCallException);
};


class TMushClientDomesticSocket: public TMushClientSocket, public TMushDomesticSocket {
  public:
    TMushClientDomesticSocket(std::string SocketPath);
    virtual void Create(void) throw(TSystemCallException);
    virtual void Connect(void) throw(TSystemCallException);
};



#endif
