/* MushFileStream.cc */
/* Created by Enomoto Sanshiro on 7 August 2003. */
/* Last updated by Enomoto Sanshiro on 7 August 2003. */


#include <iostream>
#include <cstring>
#include <string>
#include "MushFile.hh"
#include "MushFileStream.hh"

using namespace std;


static const int DefaultBufferSize = 4096;


TMushFileStreamBuffer::TMushFileStreamBuffer(TMushFile* File)
{
    _File = File;

    _BufferSize = DefaultBufferSize;
    _Buffer = new char[_BufferSize];
    
    char* Begin = _Buffer;
    char* End = _Buffer + _BufferSize;
    setp(Begin, End);
    setg(Begin, End, End);
}

TMushFileStreamBuffer::~TMushFileStreamBuffer()
{
    delete[] _Buffer;
}

int TMushFileStreamBuffer::overflow(int ch)
{
    sync();

    if (ch != EOF) {
	*pptr() = ch;
	pbump(1);
    }
    
    return ch;
}

int TMushFileStreamBuffer::underflow(void)
{
    int Size = _File->Read(_Buffer, _BufferSize);
    if (Size == 0) {
        return EOF;
    }
    else if (Size < 0) {
	// interrupted system call... try again //
	return underflow();
    }

    char* Begin = _Buffer;
    char* Next = _Buffer;
    char* End = _Buffer + Size;
    setg(Begin, Next, End);

    return *gptr();
}

int TMushFileStreamBuffer::sync(void) 
{
    if (pptr() == _Buffer) {
	return 0;
    }

    int Length = pptr() - _Buffer;
    _File->Write(_Buffer, Length);

    char* Begin = _Buffer;
    char* End = _Buffer + _BufferSize;
    setp(Begin, End);

    return 0;
}



TMushInputFileStream::TMushInputFileStream(TMushFile* File)
: istream(_StreamBuffer = new TMushFileStreamBuffer(File))
{
}

TMushInputFileStream::~TMushInputFileStream() 
{
    delete _StreamBuffer;
}

TMushFileStreamBuffer* TMushInputFileStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}


TMushOutputFileStream::TMushOutputFileStream(TMushFile* File)
: ostream(_StreamBuffer = new TMushFileStreamBuffer(File))
{
}

TMushOutputFileStream::~TMushOutputFileStream() 
{
    delete _StreamBuffer;
}

TMushFileStreamBuffer* TMushOutputFileStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}
