/* MushFileSystem.hh */
/* Created by Enomoto Sanshiro on 17 July 2001. */
/* Last updated by Enomoto Sanshiro on 15 October 2001. */


#ifndef __MushFileSystem_hh__
#define __MushFileSystem_hh__


#include <string>
#include "MushDefs.hh"


class TMushFileSystem {
  public:
    TMushFileSystem(const std::string& Path = "");
    virtual ~TMushFileSystem();
    static void ChangeDirectory(const std::string& Path) throw(TSystemCallException);
    static std::string CurrentDirectory(void) throw(TSystemCallException);
    static int MakeDirectory(const std::string& Name, int AccessMode = 0755) throw(TSystemCallException);
    static unsigned SetUMask(unsigned UMask);
    static void Unlink(const std::string& FileName) throw(TSystemCallException);
    virtual long FileSystemType(void) throw(TSystemCallException);
    virtual long BlockSize(void) throw(TSystemCallException);
    virtual long TotalNumberOfBlocks(void) throw(TSystemCallException);
    virtual long NumberOfFreeBlocks(void) throw(TSystemCallException);
    virtual long NumberOfAvailableBlocks(void) throw(TSystemCallException);
    virtual long TotalNumberOfNodes(void) throw(TSystemCallException);
    virtual long NumberOfFreeNodes(void) throw(TSystemCallException);
  protected:
    std::string _Path;
    long _BlockSize;
};


class TMushFileAttribute {
  public:
    TMushFileAttribute(const std::string& FilePathName);
    virtual ~TMushFileAttribute();
    virtual long Size(void) throw(TSystemCallException);
    virtual long AccessMode(void) throw(TSystemCallException);
    virtual long OwnerUserId(void) throw(TSystemCallException);
    virtual long OwnerGroupId(void) throw(TSystemCallException);
    virtual long LastAccessTime(void) throw(TSystemCallException);
    virtual long LastModificationTime(void) throw(TSystemCallException);
    virtual long LastChangeTime(void) throw(TSystemCallException);
    virtual unsigned long CheckSum(void) throw(TSystemCallException);
    virtual bool IsFile(void) throw(TSystemCallException);
    virtual bool IsDirectory(void) throw(TSystemCallException);
    virtual bool IsSymbolicLink(void) throw(TSystemCallException);
    virtual bool Exists(void);
    virtual bool IsReadable(void);
    virtual bool IsWritable(void);
    virtual bool IsExecutable(void);
    virtual std::string PathName(void);
    virtual std::string FileName(void);
    virtual std::string FileRootName(void);
    virtual std::string Extension(void);
  public:
    bool IsReadableFile(void) { return IsReadable() && IsFile(); }
    bool IsWritableFile(void) { return IsReadable() && IsFile(); }
    bool IsExecutableFile(void) { return IsReadable() && IsFile(); }
  protected:
    std::string _FilePathName;
};


#endif
