/* MushMisc.hh */
/* Created by Enomoto Sanshiro on 28 May 1998. */
/* Last updated by Enomoto Sanshiro on 24 September 1998. */


#ifndef __MushMisc_hh__
#define __MushMisc_hh__


#include <string>
#include <map>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include "MushDefs.hh"


class TMushDateTime {
  public:
    enum TTimeZone {
	TimeZone_Local, TimeZone_GMT
    };
  public:
    TMushDateTime(TTimeZone TimeZone = TimeZone_Local);
    TMushDateTime(long TimeValue, TTimeZone TimeZone = TimeZone_Local);
    TMushDateTime(int Year, int Month, int Day, int Hour=0, int Min=0, int Sec=0, TTimeZone = TimeZone_Local);
    TMushDateTime& Update(void);
    TMushDateTime& Set(long TimeValue);
    TMushDateTime& Set(int Year, int Month, int Day, int Hour=0, int Min=0, int Sec=0);
    long AsLong(void);
    long PassedTime(void);
    long PassedTimeUSec(void);
    std::string AsString(std::string TimeFormat = "");
    operator long () { return AsLong(); }
    long USec(void);
    int Sec(void);
    int Min(void);
    int Hour(void);
    int Day(void);
    int Month(void);
    int Year(void);
    int SecInDay(void);
    int DayInYear(void);
    int DayOfWeek(void);
    inline static long SecSinceEpoch(void);
    inline static long SecSince(long Time);
    inline static void GetTime(long& Sec, long& USec);
  protected:
    TTimeZone _TimeZone;
    struct timeval _TimeValue;
    struct tm _TimeStruct;
};


class TMushUser {
  public:
    TMushUser(void);
    TMushUser(long UserId) throw(TSystemCallException);
    TMushUser(const std::string& LoginName) throw(TSystemCallException);
    long Id(void);
    long GroupId(void);
    std::string Name(void);
    std::string GroupName(void);
    std::string HomeDirectory(void);
    std::string Shell(void);
  protected:
    long _UserId;
};


class TMushGroup {
  public:
    TMushGroup(void);
    TMushGroup(long GroupId) throw(TSystemCallException);
    TMushGroup(const std::string& GroupName) throw(TSystemCallException);
    long Id(void);
    std::string Name(void);
  protected:
    long _GroupId;
};


class TMushLocalHost {
  public:
    static std::string SystemName(void);
    static std::string SystemRelease(void);
    static std::string SystemVersion(void);
    static std::string HostName(void);
    static std::string Machine(void);
};


class TMushCpu {
  public:
    static bool IsLittleEndian(void);
};


class TMushEnvironmentVariable {
  public:
    TMushEnvironmentVariable(const std::string& Name);
    virtual ~TMushEnvironmentVariable();
    virtual std::string AsString(void) throw(TSystemCallException);
    virtual long AsLong(void) throw(TSystemCallException);
    virtual double AsDouble(void) throw(TSystemCallException);
    virtual operator const char* ();
    virtual operator const std::string& ();
  public:
    static std::string Get(const std::string& Name);
    static void Set(const std::string& Name, const std::string& Value);
    static bool IsDefined(const std::string& Name);
    static void LoadTable(std::map<std::string, std::string>& Table);
  protected:
    std::string _Name;
    std::string _Value;
};


inline long TMushDateTime::SecSinceEpoch(void) 
{ 
    return time(NULL); 
}

inline long TMushDateTime::SecSince(long Time) 
{ 
    return time(NULL) - Time;
}

inline void TMushDateTime::GetTime(long& Sec, long& USec)
{
    static struct timeval TimeValue;
    gettimeofday(&TimeValue, 0);

    Sec = TimeValue.tv_sec;
    USec = TimeValue.tv_usec;
}


#endif
