/* MushSocketStream.cc */
/* Created by Enomoto Sanshiro on 14 May 2000. */
/* Last updated by Enomoto Sanshiro on 26 June 2009. */


#include <iostream>
#include <cstring>
#include <string>
#include "MushSocket.hh"
#include "MushSocketStream.hh"

using namespace std;


static const int DefaultBufferSize = 65536;


TMushSocketStreamBuffer::TMushSocketStreamBuffer(TMushSocket* Socket)
{
    _Socket = Socket;

    _BufferSize = DefaultBufferSize;
    _InputBuffer = new char[_BufferSize];
    _OutputBuffer = new char[_BufferSize];

    {
	char* Begin = _InputBuffer;
	char* Next = _InputBuffer + _BufferSize;
	char* End = _InputBuffer + _BufferSize;
	setg(Begin, Next, End);
    }

    {
	char* Begin = _OutputBuffer;
	char* End = _OutputBuffer + _BufferSize;
	setp(Begin, End);
    }
}

TMushSocketStreamBuffer::~TMushSocketStreamBuffer()
{
    delete[] _OutputBuffer;
    delete[] _InputBuffer;
}

int TMushSocketStreamBuffer::overflow(int ch)
{
    sync();

    if (ch != EOF) {
	*pptr() = ch;
	pbump(1);
    }
    
    return ch;
}

int TMushSocketStreamBuffer::underflow(void)
{
    int Size = _Socket->Receive(_InputBuffer, _BufferSize);
    if (Size == 0) {
        return EOF;
    }
    else if (Size < 0) {
	// interrupted system call... try again //
	return underflow();
    }

    char* Begin = _InputBuffer;
    char* Next = _InputBuffer;
    char* End = _InputBuffer + Size;
    setg(Begin, Next, End);

    return *gptr();
}

int TMushSocketStreamBuffer::sync(void) 
{
    if (pptr() == _OutputBuffer) {
	return 0;
    }

    int Length = pptr() - _OutputBuffer;
    _Socket->Send(_OutputBuffer, Length);

    char* Begin = _OutputBuffer;
    char* End = _OutputBuffer + _BufferSize;
    setp(Begin, End);

    return 0;
}



TMushInputSocketStream::TMushInputSocketStream(TMushSocket* Socket)
: istream(_StreamBuffer = new TMushSocketStreamBuffer(Socket))
{
}

TMushInputSocketStream::~TMushInputSocketStream() 
{
    delete _StreamBuffer;
}

TMushSocketStreamBuffer* TMushInputSocketStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}



TMushOutputSocketStream::TMushOutputSocketStream(TMushSocket* Socket)
: ostream(_StreamBuffer = new TMushSocketStreamBuffer(Socket))
{
}

TMushOutputSocketStream::~TMushOutputSocketStream() 
{
    delete _StreamBuffer;
}

TMushSocketStreamBuffer* TMushOutputSocketStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}


TMushInputOutputSocketStream::TMushInputOutputSocketStream(TMushSocket* Socket)
: iostream(_StreamBuffer = new TMushSocketStreamBuffer(Socket))
{
}

TMushInputOutputSocketStream::~TMushInputOutputSocketStream() 
{
    delete _StreamBuffer;
}

TMushSocketStreamBuffer* TMushInputOutputSocketStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}
