/* MushTimer.hh */
/* Created by Enomoto Sanshiro on 6 May 1998. */
/* Last updated by Enomoto Sanshiro on 6 October 1999. */


#ifndef __MushTimer_hh__
#define __MushTimer_hh__

#include <sys/time.h>
#include "MushDefs.hh"
#include "MushSignal.hh"


class TMushIntervalTimer {
  public:
    TMushIntervalTimer(int TimerSignalId, unsigned long Time_sec, unsigned long Time_usec, TMushSignalClient *SignalClient = 0);
    virtual ~TMushIntervalTimer();
    virtual void SetTimeValue(unsigned long Time_sec, unsigned long Time_usec);
    virtual void GetTimeValue(unsigned long &Time_sec, unsigned long &Time_usec);
    virtual void Start(void);
    virtual void StartRepetitive(void);
    virtual void Stop(void);
    virtual void Read(unsigned long &Time_sec, unsigned long &Time_usec);
    virtual void InterruptibleSuspend(void);
    virtual void Suspend(void);
  protected:
    virtual void SetTimer(struct itimerval& TimerValue) = 0;
    virtual void GetTimer(struct itimerval& TimerValue) = 0;
  private:
    static void Handler(int SignalId);
    static TMushSignalClient *_SignalClient[NSIG];
    int _SignalId, _TimerId;
    struct itimerval _IntervalTimerValue;
    struct sigaction _OldSignalAction;
    sigset_t _AllSignalSet, _EmptySignalSet, _NonAlarmSignalSet;
};


class TMushRealTimeTimer: public TMushIntervalTimer {
  public:
    TMushRealTimeTimer(unsigned long Time_sec, unsigned long Time_usec, TMushSignalClient *SignalClient = 0): TMushIntervalTimer(SIGALRM, Time_sec, Time_usec, SignalClient) {}
    virtual ~TMushRealTimeTimer() {}
  protected:
    virtual void SetTimer(struct itimerval& TimerValue);
    virtual void GetTimer(struct itimerval& TimerValue);
};

class TMushVirtualTimeTimer: public TMushIntervalTimer {
  public:
    TMushVirtualTimeTimer(unsigned long Time_sec, unsigned long Time_usec, TMushSignalClient *SignalClient = 0): TMushIntervalTimer(SIGVTALRM, Time_sec, Time_usec, SignalClient) {}
    virtual ~TMushVirtualTimeTimer() {}
  protected:
    virtual void SetTimer(struct itimerval& TimerValue);
    virtual void GetTimer(struct itimerval& TimerValue);
};

class TMushProfileTimeTimer: public TMushIntervalTimer {
  public:
    TMushProfileTimeTimer(unsigned long Time_sec, unsigned long Time_usec, TMushSignalClient *SignalClient = 0): TMushIntervalTimer(SIGPROF, Time_sec, Time_usec, SignalClient) {}
    virtual ~TMushProfileTimeTimer() {}
  protected:
    virtual void SetTimer(struct itimerval& TimerValue);
    virtual void GetTimer(struct itimerval& TimerValue);
};


#endif
