/* MushXml.hh */
/* Created by Enomoto Sanshiro on 30 July 2003. */
/* Last updated by Enomoto Sanshiro on 30 July 2003. */


#ifndef __MushXml_hh__
#define __MushXml_hh__


#include <string>
#include <vector>
#include <map>
#include "MushDefs.hh"


class TMushSaxException: public TSystemCallException {
  public:
    TMushSaxException(const std::string& location, const std::string& message);
};
    

class TMushSaxAttributeList {
  public:
    unsigned getLength(void) const;
    const std::string& getName(unsigned index) const;
    const std::string& getValue(unsigned index) const;
    const std::string& getValue(const std::string& name) const;
  public:
    void add(const std::string& name, const std::string& value);
  protected:
    std::vector<std::string> _name_list;
    std::vector<std::string> _value_list;
    mutable std::map<std::string, std::string> _name_value_table;
};


class TMushSaxLocator {
  public:
    TMushSaxLocator(void);
    ~TMushSaxLocator();
    int getColumnNumber(void);
    int getLineNumber(void);
    const char* getPublicId(void);
    const char* getSystemId(void);
};


class TMushSaxDocumentHandler {
  public:
    TMushSaxDocumentHandler(void) {}
    virtual ~TMushSaxDocumentHandler() {}
    virtual void startDocument(void) {}
    virtual void endDocument(void) {}
    virtual void startElement(const std::string& name, const TMushSaxAttributeList& attribute_list) {}
    virtual void endElement(const std::string& name) {}
    virtual void characters(const std::string& text) {}
    virtual void ignorableWhitespace(const std::string& text) {}
    virtual void comment(const std::string& comment) {}
    virtual void warning(const std::string& message) {}
    virtual void error(const std::string& message) {}
    virtual void fatalError(const std::string& message) {}
    virtual void setDocumentLocator(TMushSaxLocator* Locator) {}
};


class TMushSaxParser {
  public:
    TMushSaxParser(void);
    virtual ~TMushSaxParser();
    virtual void setDocumentHandler(TMushSaxDocumentHandler* DocumentHandler);
    virtual void parse(const std::string& file_name) throw(TMushSaxException);
  protected:
    TMushSaxDocumentHandler* _document_handler;
};



namespace mush {
    namespace sax {
	typedef TMushSaxParser Parser;
	typedef TMushSaxDocumentHandler DocumentHandler;
	typedef TMushSaxAttributeList AttributeList;
	typedef TMushSaxLocator Locator;
	typedef TMushSaxException SAXException;
    }
}


#endif
