/* checksum-test.cc */
/* Created by Enomoto Sanshiro on 15 February 2002. */
/* Last updated by Enomoto Sanshiro on 15 February 2002. */


#include <iostream>
#include <string>
#include "MushFile.hh"
#include "MushCheckSum.hh"

using namespace std;


int main(int argc, char** argv)
{
    if (argc < 2) {
	cerr << "usage: " << argv[0] << " FileName" << endl;
	return -1;
    }
    string FileName = argv[1];

    try {
	TMushCrc32CheckSum CheckSum;

	TMushFile File(FileName);
	File.OpenReadMode();

	char Buffer[4096];
	int Size;
	while ((Size = File.Read(Buffer, sizeof(Buffer))) > 0) {
	    CheckSum.ReadData(Buffer, Size);
	}

	int FileSize = CheckSum.DataLength();
	for (int SizeData = FileSize; SizeData != 0; SizeData >>= 8) {
	    char Byte = SizeData & 0xff;
	    CheckSum.ReadData(&Byte, 1);
	}

	unsigned long Result = 0;
	for (unsigned i = 0; i < CheckSum.ResultLength(); i++) {
	    Result |= CheckSum.ByteValueAt(i) << (8 * i);
	}
	cout << Result << " " << FileSize << " " << FileName << endl;
    }
    catch (TSystemCallException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }

    return 0;
}
