/* domestic-socket-test.cc */
/* Created by Enomoto Sanshiro on 5 June 1999. */
/* Last updated by Enomoto Sanshiro on 5 May 2000. */


#include <iostream>
#include <cstring>
#include "MushDomesticSocket.hh"
#include "MushTimer.hh"

using namespace std;


int main(int argc, char **argv)
{
    if (argc < 2) {
	cerr << "usage: " << argv[0] << " SocketName" << endl;
	return -1;
    }
    
    char *SocketName = argv[1];
    TMushDomesticSocket *Socket = 0;

    try {
	try {
	    (Socket = new TMushClientDomesticSocket(SocketName))->Open();
	}
	catch (TSystemCallException &e) {
	    cerr << "unable to be client: " << e << endl;
	    cerr << "wait connection as server..." << endl;
	    (Socket = new TMushServerDomesticSocket(SocketName))->Open();
	}
    }
    catch (TSystemCallException &e) {
        cerr << e << endl;
	return -1;
    }

    cout << "press <ENTER> to receive message." << endl;
    
    TMushRealTimeTimer TimeKeeper(0, 100000);
    static char Line[256];    
    while (
	cout << SocketName << "> " << flush, 
	cin.getline(Line, sizeof(Line), '\n')
    ){
	if (strlen(Line) > 0) {
	    strcat(Line, "\n");
	    Socket->Send(Line, strlen(Line));
	}

	TimeKeeper.Start();
	int Length = Socket->Receive(Line, sizeof(Line));
	TimeKeeper.Stop();
	
	if (Length > 0) {
	    cout << Line << flush;
	}
    }

    Socket->Close();
    delete Socket;

    cout << endl << endl;

    return 0;
}
