/* network-socket-test.cc */
/* Created by Enomoto Sanshiro on 5 August 1998. */
/* Last updated by Enomoto Sanshiro on 5 May 2000. */


#include <iostream>
#include <string>
#include "MushNetworkSocket.hh"
#include "MushTimer.hh"
#include "MushArgumentList.hh"

using namespace std;


int main(int argc, char **argv)
{
    if (argc < 3) {
	cerr << "usage: " << argv[0] << " HostName PortNumber" << endl;
	return -1;
    }

    TMushArgumentList ArgumentList(argc, argv);
    string HostName;
    int PortNumber;
    TMushNetworkSocket *Socket = 0;
    
    try {
	HostName = ArgumentList[0];
	PortNumber = ArgumentList.IntParameterOf(1);

	try {
	    Socket = new TMushClientNetworkSocket(HostName, PortNumber);
	    Socket->Open();
	}
	catch (TSystemCallException &e) {
	    cerr << "unable to find server: " << e << endl;
	    cerr << "wait connection as server..." << endl;

	    TMushServerNetworkSocket* ServerSocket;
	    ServerSocket = new TMushServerNetworkSocket(PortNumber);
	    ServerSocket->EnableLocalAddressReuse();
	    ServerSocket->Open();

	    Socket = ServerSocket;
	}
    }
    catch (TSystemCallException &e) {
        cerr << e << endl;
	return -1;
    }

    cout << "press <ENTER> to receive message." << endl;
    
    TMushRealTimeTimer TimeKeeper(0, 100000);
    static char Line[256];    
    while (
	cout << HostName << ":" << PortNumber << "> " << flush, 
	cin.getline(Line, sizeof(Line), '\n')
    ){
	if (strlen(Line) > 0) {
	    strcat(Line, "\n");
	    Socket->Send(Line, strlen(Line));
	}

	TimeKeeper.Start();
	int Length = Socket->Receive(Line, sizeof(Line));
	TimeKeeper.Stop();
	
	if (Length > 0) {
	    cout << Line << flush;
	}
    }

    Socket->Close();
    delete Socket;

    cout << endl << endl;

    return 0;
}
