/* shared-memory-test.cc */
/* Created by Enomoto Sanshiro on 12 February 1998. */
/* Last updated by Enomoto Sanshiro on 5 May 2000. */


#include <iostream>
#include <cstring>
#include "MushIpc.hh"
#include "MushTimer.hh"

using namespace std;


static const int Size = 256;
static const int ProjectID = 123;
static const string DisconnectMessage = "\x1bye";
static const long SamplingInterval_usec = 500000;


void Write(char *SharedBuffer) 
{
    SharedBuffer[0] = '\0';

    char Message[Size];
    while (cout << "Message> " << flush, cin.getline(Message, Size, '\n')) {
	strcpy(SharedBuffer, Message);
    }

    strcpy(SharedBuffer, DisconnectMessage.c_str());
}


void Read(char *SharedBuffer) 
{
    // Wait for shared memory is initialized...
    while (*SharedBuffer != '\0') {
	TMushRealTimeTimer(0, SamplingInterval_usec).Suspend();
    }

    // Wait for writer process writes something...
    while (*SharedBuffer == '\0') {
	TMushRealTimeTimer(0, SamplingInterval_usec).Suspend();
    }

    while (1) {
	if (SharedBuffer == DisconnectMessage) {
	    break;
	}
	cout << SharedBuffer << endl;

	TMushRealTimeTimer(0, SamplingInterval_usec).Suspend();
    }
}


int main(int argc, char** argv)
{
    TMushSharedMemory *SharedMemory = 0;

    try {
	if ((argc > 1) && (argv[1][1] == 'r')) {
	    SharedMemory = new TMushServerSharedMemory(Size, ProjectID);
	    cerr << "SHM: " << (void*) SharedMemory->BasePointer() << endl;
	    Read((char*) SharedMemory->BasePointer());
	}
	else if ((argc > 1) && (argv[1][1] == 'w')) {
	    SharedMemory = new TMushClientSharedMemory(ProjectID);
	    cerr << "SHM: " << (void*) SharedMemory->BasePointer() << endl;
	    Write((char*) SharedMemory->BasePointer());
	}
	else {
	    cerr << "usage: " << endl;
	    cerr << "  as reader:" << argv[0] << " -r" << endl;
	    cerr << "  as writer:" << argv[0] << " -w" << endl;
	}
    }
    catch (TSystemCallException e) {
	cerr << e << endl;
	cerr << "(reader process (" << argv[0] << " -r) ";
	cerr << "must be launched before writer process is launched)" << endl; 
    }
    cout << endl;

    delete SharedMemory;

    return 0;
}
