/* thread-test.cc */
/* Created by Enomoto Sanshiro on 14 August 1998. */
/* Last updated by Enomoto Sanshiro on 5 May 2000. */


#include <iostream>
#include <cctype>
#include <unistd.h>
#include "MushThread.hh"

using namespace std;


string Message = "hello, world.";


// Concrete thread class
class TMyThread: public TMushThread {
  public:
    virtual void Run(void) {
	for (unsigned i = 0; i < Message.size(); i++) {
	    cout << Message[i] << flush;
	    sleep(1);
	}
	cout << endl;
    }
};


// Another way for threading
class TMyRunnable: public TMushRunnable {
  public:
    virtual void Run(void) {
	for (unsigned i = 0; i < Message.size(); i++) {
	    cout << Message[i] << flush;
	    sleep(2);
	}
	cout << endl;
    }
};


// Check whether virtual call works correctly...
class TMyDelivedThread: public TMyThread {
  public:
    virtual void Run(void) {
	for (unsigned i = 0; i < Message.size(); i++) {
	    cout << (char) toupper(Message[i]) << flush;
	    sleep(1);
	}
	cout << endl;
    }
};


int main(void)
{
    TMyThread Thread1;
    TMushThread *Thread2 = new TMyDelivedThread();

    TMyRunnable Runnable;
    TMushThread Thread3(Runnable);

    Thread1.Start();
    Thread2->Start();
    Thread1.Detach();
    Thread2->Join();

    Thread1.Start();
    Thread3.Start();
    Thread1.Join();
    Thread3.Join();

    return 0;
}
