/* xml-test.cc */
/* Created by Enomoto Sanshiro on 30 July 2003. */
/* Last updated by Enomoto Sanshiro on 30 July 2003. */


#include <iostream>
#include <string>
#include "MushXml.hh"

using namespace mush;
using namespace std;


class XmlFileViewer: public sax::DocumentHandler {
  public:
    XmlFileViewer(void);
    virtual ~XmlFileViewer();
    virtual void go(const std::string& file_name) throw(sax::SAXException);
  public:
    virtual void endDocument(void);
    virtual void startElement(const std::string& name, const TMushSaxAttributeList& attribute_list);
    virtual void endElement(const std::string& name);
    virtual void characters(const std::string& text);
    virtual void setDocumentLocator(sax::Locator* locator);
    virtual void error(const std::string& message);
  protected:
    sax::Parser* _parser;
    sax::Locator* _locator;
};



XmlFileViewer::XmlFileViewer(void)
{
    _locator = new sax::Locator;
    _parser = new sax::Parser;
    _parser->setDocumentHandler(this);
}

XmlFileViewer::~XmlFileViewer()
{
    delete _parser;
}

void XmlFileViewer::go(const string& file_name) throw(sax::SAXException)
{
    _parser->parse(file_name);
}

void XmlFileViewer::endDocument(void)
{
    cout << endl;
}

void XmlFileViewer::startElement(const string& name, const TMushSaxAttributeList& attribute_list)
{
    //cout << "[" << _locator->getLineNumber() << "]";

    cout << "<" << name;
    for (unsigned i = 0; i < attribute_list.getLength(); i++) {
	cout << " " << attribute_list.getName(i);
	cout << "=\"" << attribute_list.getValue(i) << "\"";
    }
    cout << ">";
}

void XmlFileViewer::endElement(const string& name)
{
    //cout << "[" << _locator->getLineNumber() << "]";

    cout << "</" << name << ">";
}

void XmlFileViewer::characters(const string& text)
{
    cout << text;
}

void XmlFileViewer::setDocumentLocator(sax::Locator* locator)
{
    _locator = locator;
}

void XmlFileViewer::error(const std::string& message)
{
    cout << "ERROR: line " << _locator->getLineNumber() << ": " << message << endl;
}


int main(int argc, char** argv)
{
    if (argc < 2) {
	cerr << "Usage: " << argv[0] << " file_name" << endl;
	return -1;
    }

    XmlFileViewer xml_file_viewer;

    try {
	xml_file_viewer.go(argv[1]);
    }
    catch (sax::SAXException &e) {
	cerr << "ERROR: " << e << endl;
    }

    return 0;
}
