/* CanvasMessenger.cc */
/* Created by Enomoto Sanshiro on 19 October 2001. */
/* Last updated by Enomoto Sanshiro on 19 October 2001. */


#include "Canvas.hh"
#include "ParaObject.hh"
#include "CanvasMessenger.hh"

using namespace std;


TCanvasMessenger::TCanvasMessenger(TCanvas* Canvas)
: TParaObjectPrototype("Canvas")
{
    _Canvas = Canvas;
}

TCanvasMessenger::~TCanvasMessenger()
{
}

TParaObjectPrototype* TCanvasMessenger::Clone(void)
{
    return new TCanvasMessenger(_Canvas);
}

void TCanvasMessenger::Construct(const string& ClassName, vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    throw TScriptException(
	"Canvas: direct object creation is prohibited"
    );
}

void TCanvasMessenger::Destruct(void) throw(TScriptException)
{
    throw TScriptException(
	"Canvas: direct object destruction is prohibited"
    );
}

int TCanvasMessenger::InvokeMethodByName(const string& MethodName, vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if (MethodName == "drawLine") {
        ReturnValue = DrawLine(ArgumentList);
    }
    else if (MethodName == "drawRect") {
        ReturnValue = DrawRect(ArgumentList);
    }
    else if (MethodName == "drawCircle") {
        ReturnValue = DrawCircle(ArgumentList);
    }
    else if (MethodName == "drawText") {
        ReturnValue = DrawText(ArgumentList);
    }
    else {
	return 0;
    }

    return 1;
}

TParaValue TCanvasMessenger::DrawLine(vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (ArgumentList.size() < 4) {
	throw TScriptException("Canvas::drawLine(): too few arguments");
    }

    float X0 = ArgumentList[0]->AsDouble();
    float Y0 = ArgumentList[1]->AsDouble();
    float X1 = ArgumentList[2]->AsDouble();
    float Y1 = ArgumentList[3]->AsDouble();

    _Canvas->DrawLine(X0, Y0, X1, Y1);

    return TParaValue((long) 0);
}

TParaValue TCanvasMessenger::DrawRect(vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (ArgumentList.size() < 4) {
	throw TScriptException("Canvas::drawRect(): too few arguments");
    }

    float X0 = ArgumentList[0]->AsDouble();
    float Y0 = ArgumentList[1]->AsDouble();
    float X1 = ArgumentList[2]->AsDouble();
    float Y1 = ArgumentList[3]->AsDouble();

    _Canvas->DrawRect(X0, Y0, X1, Y1);

    return TParaValue((long) 0);
}

TParaValue TCanvasMessenger::DrawCircle(vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (ArgumentList.size() < 3) {
	throw TScriptException("Canvas::drawCircle(): too few arguments");
    }

    float X0 = ArgumentList[0]->AsDouble();
    float Y0 = ArgumentList[1]->AsDouble();
    float Radius = ArgumentList[2]->AsDouble();

    _Canvas->DrawCircle(X0, Y0, Radius);

    return TParaValue((long) 0);
}

TParaValue TCanvasMessenger::DrawText(vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (ArgumentList.size() < 3) {
	throw TScriptException("Canvas::drawText(): too few arguments");
    }

    float X0 = ArgumentList[0]->AsDouble();
    float Y0 = ArgumentList[1]->AsDouble();
    string Text = ArgumentList[2]->AsString();

    _Canvas->DrawText(X0, Y0, Text);

    return TParaValue((long) 0);
}



TCanvasFactory::TCanvasFactory(TCanvasMessenger* CanvasMessenger)
: TParaObjectPrototype("CanvasFactory")
{
    _CanvasMessenger = CanvasMessenger;
    _CanvasPointer = new TParaValue(_CanvasMessenger);
}

TCanvasFactory::~TCanvasFactory()
{
    delete _CanvasPointer;
}

TParaObjectPrototype* TCanvasFactory::Clone(void)
{
    return new TCanvasFactory(_CanvasMessenger);
}

void TCanvasFactory::Construct(const string& ClassName, vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
}

int TCanvasFactory::InvokeMethodByName(const string& MethodName, vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if (MethodName == "getCanvas") {
        ReturnValue = GetCanvas(ArgumentList);
    }
    else {
	return 0;
    }

    return 1;
}

TParaValue TCanvasFactory::GetCanvas(vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    return TParaValue(_CanvasPointer);
}
