/* RoomCamacAccess.hh */
/* Created by Enomoto Sanshiro on 23 October 1997. */
/* Last updated by Enomoto Sanshiro on 9 August 2002. */


#ifndef __RoomCamacAccess_hh__
#define __RoomCamacAccess_hh__


#include <string>
#include <vector>
#include "RoomDefs.hh"
#include "RoomDeviceBase.hh"
#include "RoomModule.hh"


class TRoomCamacModule;

class TRoomCamacController: public TRoomController {
  public:
    TRoomCamacController(void);
    virtual ~TRoomCamacController();
    virtual TRoomCamacController* CloneController(void) = 0;
  public:
    virtual void Open(void) throw(THardwareException) = 0;
    virtual void Close(void);
    virtual int Transact(int StationNumber, int Function, int Address, int &Data, int &Q, int &X) throw(THardwareException) = 0;
    virtual int Initialize(void) throw(THardwareException) = 0;
    virtual int Clear(void) throw(THardwareException) = 0;
    virtual int SetInhibit(void) throw(THardwareException) = 0;
    virtual int ReleaseInhibit(void) throw(THardwareException) = 0;
    virtual int EnableInterruptNotification(void) throw(THardwareException) = 0;
    virtual int DisableInterruptNotification(void) throw(THardwareException) = 0;
    virtual bool IsSignalOnInterruptAvailable(void);
    virtual int ReadLam(int LamMask) throw(THardwareException) = 0;
    virtual int WaitLam(int TimeOut_sec) throw(THardwareException) = 0;
};


class TRoomNullCamacController: public TRoomCamacController {
  public:
    TRoomNullCamacController(void);
    virtual ~TRoomNullCamacController();
    virtual TRoomCamacController* CloneController(void);
  public:
    virtual void Open(void) throw(THardwareException);
    virtual void Close(void);
    virtual int Transact(int StationNumber, int Function, int Address, int &Data, int &Q, int &X) throw(THardwareException);
    virtual int Initialize(void) throw(THardwareException);
    virtual int Clear(void) throw(THardwareException);
    virtual int SetInhibit(void) throw(THardwareException);
    virtual int ReleaseInhibit(void) throw(THardwareException);
    virtual int EnableInterruptNotification(void) throw(THardwareException);
    virtual int DisableInterruptNotification(void) throw(THardwareException);
    virtual int ReadLam(int LamMask) throw(THardwareException);
    virtual int WaitLam(int TimeOut_sec) throw(THardwareException);
};


class TRoomCheckerCamacController: public TRoomCamacController {
  public:
    TRoomCheckerCamacController(void);
    virtual ~TRoomCheckerCamacController();
    virtual TRoomCamacController* CloneController(void);
  public:
    virtual void Open(void) throw(THardwareException);
    virtual void Close(void);
    virtual int Transact(int StationNumber, int Function, int Address, int &Data, int &Q, int &X) throw(THardwareException);
    virtual int Initialize(void) throw(THardwareException);
    virtual int Clear(void) throw(THardwareException);
    virtual int SetInhibit(void) throw(THardwareException);
    virtual int ReleaseInhibit(void) throw(THardwareException);
    virtual int EnableInterruptNotification(void) throw(THardwareException);
    virtual int DisableInterruptNotification(void) throw(THardwareException);
    virtual int ReadLam(int LamMask) throw(THardwareException);
    virtual int WaitLam(int TimeOut_sec) throw(THardwareException);
};


class TRoomCamacCrate: public TRoomCrate {
  public:
    TRoomCamacCrate(void);
    TRoomCamacCrate(TRoomCamacController *Controller);
    virtual ~TRoomCamacCrate();
    virtual void InstallController(TRoomCamacController *Controller);
    virtual void Install(TRoomCamacModule *CamacModule, int StationNumber) throw(THardwareException);
    virtual void Uninstall(TRoomCamacModule *CamacModule);
    virtual TRoomCamacController* CamacController(void) const;
  private:
    TRoomCamacController *_CamacController;
    std::vector<TRoomCamacModule*> _ModuleList;
};


class TRoomCamacModule: public TRoomModule {
  public:
    TRoomCamacModule(void);
    TRoomCamacModule(const std::string& ModuleType, const std::string& ModelName);
    virtual ~TRoomCamacModule();
    virtual TRoomCamacModule* Clone(void) = 0;
    virtual void Destroy(void);
  public:
    // CAMAC access functions //
    int Transact(int Function, int Address, int &Data, int &Q, int &X);
    int Transact(int Function, int Address, int &Data) throw(THardwareException);
    int Transact(int Function, int Address) throw(THardwareException);
    int EnableLam(void) throw(THardwareException);
    int DisableLam(void) throw(THardwareException);
    int ClearLam(void) throw(THardwareException);
    bool WaitLam(int TimeOut_sec) throw(THardwareException);
    bool IsRequestingLam(void);
  public:
    // Common implementations of the Module interface //
    virtual int Read(int Address, int& Data) throw(THardwareException);
    virtual int Write(int Address, int Data) throw(THardwareException);
    virtual int ReadRegister(int Address, int& Data) throw(THardwareException);
    virtual int WriteRegister(int Address, int Data) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual bool HasData(int Address = -1) throw(THardwareException);
    virtual bool WaitData(unsigned TimeOut_sec = 1) throw(THardwareException);
    virtual int EnableInterrupt(int SignalId = 0) throw(THardwareException);
    virtual int DisableInterrupt(void) throw(THardwareException);
    virtual int ClearInterrupt(void) throw(THardwareException);
    virtual int AddressBitLength(void);
    virtual int DataBitLength(void);
  public:
    // Common implementations of the ServiceRequester interface //
    virtual void EnableServiceRequest(void) throw(THardwareException);
    virtual void DisableServiceRequest(void) throw(THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
    virtual bool IsRequestingService(void) throw(THardwareException);
    virtual bool IsSignalOnSerivceRequestAvailable(void);
  public:
    // Miscellaneous features //
    virtual void SetInvalidDataValue(int Value);
  private:
    friend class TRoomCamacCrate;
    void Attach(TRoomCamacCrate* Crate, int StationNumber);
    void Detach(void);
  protected:
    enum TCamacFunctionTable {
	fnRead = 0,
	fnTestLam = 8,
	fnClear = 9,
	fnClearLam = 10,
	fnWrite = 16,
	fnDisable = 24,
	fnEnable = 26,
	_NumberOfCamacFunctions
    };
    enum TCamacAddressTable {
	adAny = 0,
	_NumberOfCamacAddresses
    };
    TRoomCamacCrate *_CamacCrate;
    TRoomCamacController *_CamacController;
    TRoomCamacController *_CheckerCamacController;
    int _StationNumber;
    unsigned _StationNumberBit;
    bool _IsLamEnabled;
    bool _IsInvalidDataValueSet;
    int _InvalidDataValue;
};

#endif
