/* RoomServiceRequester.hh */
/* Created by Enomoto Sanshiro on 7 July 2001. */
/* Last updated by Enomoto Sanshiro on 29 March 2002. */


#ifndef __RoomServiceRequester_hh__
#define __RoomServiceRequester_hh__


#include "RoomConfig.hh"
#include "RoomDefs.hh"


class TRoomServiceRequester {
  public:
    TRoomServiceRequester(void);
    virtual ~TRoomServiceRequester();

    // Basic Interface //
    virtual bool WaitForServiceRequest(int TimeOut_sec) throw(THardwareException);
    virtual int RequestingServiceNumber(void) throw(THardwareException);

    // Polling Interface //
    virtual void EnableServiceRequest(void) throw(THardwareException);
    virtual void DisableServiceRequest(void) throw(THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
    virtual bool IsRequestingService(void) throw(THardwareException);

    // Signal on Service Request //
    virtual bool IsSignalOnServiceRequestAvailable(void);
    virtual void EnableSignalOnServiceRequest(int SignalId) throw(THardwareException);
    virtual void DisableSignalOnServiceRequest(void) throw(THardwareException);
};


class TRoomServiceRequestHandler {
  public:
    TRoomServiceRequestHandler(void);
    virtual ~TRoomServiceRequestHandler();
    virtual void SetPollingInterval(int Interval_usec);
    virtual void ForcePolling(void);
    virtual void RegisterRequester(TRoomServiceRequester* Requester, int RequesterId);
    virtual void Initialize(void) throw(THardwareException);
    virtual void Finalize(void) throw(THardwareException);
    virtual bool WaitForServiceRequest(int& RequesterId, int& RequestNumber, int TimeOut_sec = 1) throw(THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
  protected:
    virtual int LookForRequestSignal(int TimeOut_sec) throw(THardwareException);
    virtual int PollRequest(int TimeOut_sec) throw(THardwareException);
  protected:
    int _NumberOfRequesters;
    int _RequesterListCapacity;
    TRoomServiceRequester** _RequesterList;
    int* _RequesterIdList;
    bool _IsSignalAvailable;
    int _PollingInterval_usec;
    TRoomServiceRequester* _RequestingRequester;
    bool _IsPollingForced;
  private:
    void StartSignalHandling(void);
    void StopSignalHandling(void);
    int WaitForSignal(int TimeOut_sec);
    static void SignalHandler(int SignalId);
    static const int _SignalId;
    static int _SignalCount;
    static void (*_OldSignalHandler)(int);
};


#endif
