/* bridge-Toyo_CCNET.hh */
/* Created by Enomoto Sanshiro on 22 July 2009. */
/* Last updated by Enomoto Sanshiro on 15 January 2010. */


#ifndef __bridge_Toyo_CCNET_hh__
#define __bridge_Toyo_CCNET_hh__


#include "RoomNetworkBridge.hh"


class TMiscDevice_Toyo_CCNET {
  public:
    TMiscDevice_Toyo_CCNET(TRoomNetworkConnection* NetworkConnection);
    virtual ~TMiscDevice_Toyo_CCNET(void);
    void CCNET_Open(void) throw(THardwareException);
    void CCNET_Close(void) throw(THardwareException);
    void CCNET_Reset(void) throw(THardwareException);
    void CCNET_ClearFifo(void) throw(THardwareException);
    void CCNET_EnableLam(int LamPattern = 0x00ffffff) throw(THardwareException);
    void CCNET_DisableLam(void) throw(THardwareException);
    int CCNET_WaitLam(int Timeout) throw(THardwareException);
    void CCNET_EnableTrigger(void) throw(THardwareException);
    void CCNET_DisableTrigger(void) throw(THardwareException);
    int CCNET_WaitTrigger(int Timeout) throw(THardwareException);
    void CCNET_Put(int Data, int Command) throw(THardwareException);
    void CCNET_Get(int& Data, int& Reply) throw(THardwareException);
  public:
    // Pipeline Execution //
    int* CCNET_CreateBuffer(void);
    void CCNET_DestroyBuffer(int* Buffer);
    int CCNET_ExecuteFrame(int Command, const int* CommandBuffer, int* ReplyBuffer) throw(THardwareException);
    int CCNET_ExecutePio(const int* CommandBuffer, int* ReplyBuffer) throw(THardwareException);
    int CCNET_ExecuteDma(const int* CommandBuffer, int* ReplyBuffer) throw(THardwareException);
    int CCNET_ExecuteDmaSequence(const int* CommandBuffer, int* ReplyBuffer) throw(THardwareException);
    int CCNET_Execute(const int* CommandBuffer, int* ReplyBuffer) throw(THardwareException);
  public:
    // Frame Formatting and Scanning //
    void CCNET_FillCamacCommandTo(int Command[2], int N, int A, int F, int Data, int FrameFlag = 0);
    void CCNET_FillDaqCommandTo(int Command[2], int Function, int FrameFlag = 0);
    void CCNET_ExtractCamacReplyFrom(int Reply[2], int& N, int& A, int& F, int& Data, int&Q, int&X);
    void CCNET_ExtractDaqReplyFrom(int Reply[2], int& Data, int& Status);
    bool CCNET_IsCamacReply(int Reply[2]);
  public:
    // Command Buffer Building //
    void CCNET_InitializeCommandBuffer(int* CommandBuffer) throw(THardwareException);
    void CCNET_CompleteCommandBuffer(int* CommandBuffer) throw(THardwareException);
    void CCNET_LoadCamacCommand(int* CommandBuffer, int N, int A, int F, int Data) throw(THardwareException);
    void CCNET_LoadDaqCommand(int* CommandBuffer, int Command, int Data) throw(THardwareException);
  public:
    // Common Construction //
    void CCNET_ExecuteSingleCamac(int N, int A, int F, int& Data, int& Q, int& X) throw(THardwareException);
    void CCNET_ExecuteSingleDaq(int Function, int& Data, int& Status) throw(THardwareException);
  private:
    int* _ReceiveBuffer;
    int* _SendBuffer;
    TRoomNetworkConnection* _Connection;
  public:
    enum TParameters {
	_WordSize = sizeof(int),
	_MaxBufferSize = 128 * 1024,
	_MaxFrameLength = _MaxBufferSize/8-2,
	_PacketHeaderSize = 2 * _WordSize,
	_BufferSize = 64 * _WordSize,  // > sizeof(struct pccreg)
	_PacketSize = _PacketHeaderSize + _BufferSize,
	_NumberOfParameters
    };
    enum TPacketOffset {
	Offset_TotalSize = 0,
	Offset_Command = 1,
	Offset_DataStart = 3,      // Data Packet
	Offset_FrameCapacity = 3,  // CMD/RCV Packet
	Offset_NumberOfFrames = 4, // CMD/RCV Packet
	Offset_FrameStart = 5,     // CMD/RCV Packet
	_OffsetTableSize
    };
    enum TCommand {
	Command_Open = 1,
	Command_Close = 2,
	Command_Reset = 4,
	Command_ClearFifo = 5,
	Command_EnableLam = 10,
	Command_WaitLam = 11,
	Command_DisableLam = 12,
	Command_EnableTrigger = 13,
	Command_WaitTrigger = 14,
	Command_DisableTrigger = 15,
	Command_Get = 101,
	Command_Put = 102,
	Command_GetInterrupt = 103,
	Command_ExecutePio = 104,
	Command_ExecuteDma = 105,
	Command_ExecuteDmaSequence = 106,
	Command_Execute = 107,
	_NumberOfCommands
    };
    enum TFrameFlag {
	FrameFlag_Normal = 0x80,
	FrameFlag_Start = 0xC0,
	FrameFlag_End = 0xA0,
	FrameFlag_Packet = 0xE0,
	FrameFlag_Camac = 0x00,
	FrameFlag_Daq = 0x10,
	_NumberOfFrameFlags
    };
};


class TNetworkCamacBridge_Toyo_CCNET: public TRoomNetworkCamacBridge, public TMiscDevice_Toyo_CCNET {
  public:
    TNetworkCamacBridge_Toyo_CCNET(void);
    virtual ~TNetworkCamacBridge_Toyo_CCNET();
    virtual TRoomNetworkCamacBridge* CloneBridge(void);
  public:
    // Camac Controller Interface //
    virtual void Open(void) throw(THardwareException);
    virtual void Close(void);
    virtual int Transact(int StationNumber, int Function, int Address, int &Data, int &Q, int &X) throw(THardwareException);
    virtual int Initialize(void) throw(THardwareException);
    virtual int Clear(void) throw(THardwareException);
    virtual int SetInhibit(void) throw(THardwareException);
    virtual int ReleaseInhibit(void) throw(THardwareException);
    virtual int EnableInterruptNotification(void) throw(THardwareException);
    virtual int DisableInterruptNotification(void) throw(THardwareException);
    virtual int ReadLam(int LamMask) throw(THardwareException);
    virtual int WaitLam(int TimeOut_sec) throw(THardwareException);
  public:
    // Network Module Interface //
    virtual int AddressBitLength(void);
    virtual int DataBitLength(void);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Finalize(int FinalState = 0) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException);
    virtual int NextDataBlockSize(int Address = -1) throw(THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
    virtual bool WaitForServiceRequest(int TimeOut_sec) throw(THardwareException);
    virtual bool IsRequestingService(void) throw(THardwareException);
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
  public:
  public:
    enum TControlId {
	ControlId_ExecuteSingleCamac,
	ControlId_ExecuteSingleDaq,
	ControlId_InitializeCommandBuffer,
	ControlId_LoadCamacCommand,
	ControlId_LoadDaqCommand,
	ControlId_Execute,
	ControlId_ExecutePio,
	ControlId_ExecuteDma,
	ControlId_ExecuteDmaSequence,
	_NumberOfControls
    };
  private:
    bool _IsOpened, _IsInterruptNotificationEnabled;
    int* _CommandBuffer;
    int* _ReplyBuffer;
    int _ReplySize;
};


#endif
