/* Kek_Camlib.cc */
/* Created by Enomoto Sanshiro on 6 October 1997. */
/* Updated by Enomoto Sanshiro on 8 July 2001. */
/* Last updated by Enomoto Sanshiro on 20 July 2009. */


#include <camlib.h>
#include "RoomDeviceFactory.hh"
#include "controller-Kek_Camlib.hh"

using namespace std;


static TRoomCamacControllerCreator Creator1(
    "KEK_Camlib", new TCamacController_Kek_Camlib()
);
static TRoomCamacControllerCreator Creator2(
    "Toyo_CCNET", new TCamacController_Kek_Camlib()
);
static TRoomCamacControllerCreator Creator3(
    "KEK_CCNET", new TCamacController_Kek_Camlib()
);


TCamacController_Kek_Camlib::TCamacController_Kek_Camlib(void)
{
    _IsOpened = false;
    _IsInterruptNotificationEnabled = false;
}

TCamacController_Kek_Camlib::~TCamacController_Kek_Camlib()
{
    Close();
}

TRoomCamacController* TCamacController_Kek_Camlib::CloneController(void)
{
    return new TCamacController_Kek_Camlib();
}

void TCamacController_Kek_Camlib::Open(void) throw(THardwareException)
{
    if (_IsOpened) {
	return;
    }

    int Status = CAM_Open();
    if (Status == 0) {
	_IsOpened = true;
    }

    Status += CSETCR(0);

    Status += CGENC();
    Status += CGENZ();
    Status += CREMI();

    if (Status != 0) {
	throw THardwareException(
            "TCamacController_Kek_Camlib::Open()",
            "Initialization fault"
        );
    }
}

void TCamacController_Kek_Camlib::Close(void)
{
    if (_IsInterruptNotificationEnabled) {
	try {
	    DisableInterruptNotification();
	}
	catch (THardwareException &e) {
	}
    }

    if (_IsOpened) {
	CAM_Close();
	_IsOpened = false;
    }
}

int TCamacController_Kek_Camlib::EnableInterruptNotification(void) throw(THardwareException)
{
    if (_IsInterruptNotificationEnabled) {
	return 0;
    }

    unsigned LamMask = ~0;
    int Status = CAM_EnableLAM(LamMask);
    if (Status != 0) {
	throw THardwareException(
            "TCamacController_Kek_Camlib::EnableLam()",
            "LAM enable fault"
        );
    }

    _IsInterruptNotificationEnabled = true;

    return Status;
}

int TCamacController_Kek_Camlib::DisableInterruptNotification(void) throw(THardwareException)
{
    if (! _IsInterruptNotificationEnabled) {
	return 0;
    }

    int Status = CAM_DisableLAM();

    if (Status != 0) {
	throw THardwareException(
            "TCamacController_Kek_Camlib::DisableLam()",
            "LAM disable fault"
        );
    }

    return Status;
}

int TCamacController_Kek_Camlib::ReadLam(int LamMask) throw(THardwareException)
{
    //... TODO: this is very inefficient ...//

    static const int fnTestLam = 8;

    int LamPattern = 0;
    int StationBit, Data, Q, X;
    for (int Station = 1; Station <= 24; Station++) {
	StationBit = Bit(Station);
	if (StationBit & LamMask) {
	    Transact(Station, fnTestLam, 0, Data, Q, X);
	    if (Q) {
		LamPattern |= StationBit;
	    }
	}
    }

    return LamPattern;
}

int TCamacController_Kek_Camlib::WaitLam(int TimeOut) throw(THardwareException)
{
    if (! _IsInterruptNotificationEnabled) {
	EnableInterruptNotification();
    }

    return CAM_WaitLAM(TimeOut);
}

int TCamacController_Kek_Camlib::Transact(int StationNumber, int Function, int Address, int &Data, int &Q, int &X) throw(THardwareException)
{
    static int Result;
    Result = CAMAC(NAF(StationNumber, Address, Function), &Data, &Q, &X);
    Data &= 0x00FFFFFF;

    return Result;
}

int TCamacController_Kek_Camlib::Initialize(void) throw(THardwareException)
{
   return CGENZ(); 
}

int TCamacController_Kek_Camlib::Clear(void) throw(THardwareException)
{
    return CGENC();
}

int TCamacController_Kek_Camlib::SetInhibit(void) throw(THardwareException)
{
    return CSETI();
}

int TCamacController_Kek_Camlib::ReleaseInhibit(void) throw(THardwareException)
{
    return CREMI();
}

