/* Toyo_CCNET.cc */
/* Created by Enomoto Sanshiro on 20 July 2009. */
/* Last updated by Enomoto Sanshiro on 20 July 2009. */


#include <cstring>
#include <cerrno>
#include <camlib.h>
#include "RoomDeviceFactory.hh"
#include "controller-Toyo_CCNET.hh"

using namespace std;


extern "C" {
int cam_open(void);
int cam_close(int fd);
int cam_single_cc(int fd, int n, int a, int f, int *data, int *q, int *x);
int cam_reset(int fd);
int cam_enable_lam(int fd, int enable_pattern);
int cam_wait_lam(int fd, int* lam_pattern, int timeout);
int cam_disable_lam(int fd);
int cam_wait_trig(int fd, int* event_count, int timeout);
}


static TRoomCamacControllerCreator Creator1(
    "Toyo_CCNET", new TCamacController_Toyo_CCNET()
);



TCamacController_Toyo_CCNET::TCamacController_Toyo_CCNET(void)
{
    _Device = -1;
}

TCamacController_Toyo_CCNET::~TCamacController_Toyo_CCNET()
{
    Close();
}

TRoomCamacController* TCamacController_Toyo_CCNET::CloneController(void)
{
    return new TCamacController_Toyo_CCNET();
}

void TCamacController_Toyo_CCNET::Open(void) throw(THardwareException)
{
    if (_Device > 0) {
	return;
    }

    _Device = cam_open();
    if (_Device < 0) {
	throw THardwareException(
	    "TCamacController_Toyo_CCNET::Open(): open(2)",
	    strerror(errno)
	);
    }

    if (cam_reset(_Device) < 0) {
	throw THardwareException(
	    "TCamacController_Toyo_CCNET::Open()",
	    "error on cam_reset()"
	);
    }
}

void TCamacController_Toyo_CCNET::Close(void)
{
    if (_Device > 0) {
        cam_close(_Device);
    }
}

int TCamacController_Toyo_CCNET::EnableInterruptNotification(void) throw(THardwareException)
{
    int Result;
    int Pattern = 0x00ffffff;

    Result = cam_enable_lam(_Device, Pattern);
    if (Result) {
	throw THardwareException(
	    "TCamacController_Toyo_CCNET::EnableInterruptNotification()",
	    "error on cam_enable_lam()"
        );
    }

    return 0;
}

int TCamacController_Toyo_CCNET::DisableInterruptNotification(void) throw(THardwareException)
{
    int Result;
    Result = cam_disable_lam(_Device);
    if (Result) {
	throw THardwareException(
	    "TCamacController_Toyo_CCNET::DisableInterruptNotification()",
	    "error on cam_disable_lam()"
        );
    }

    return 0;
}

int TCamacController_Toyo_CCNET::Initialize(void) throw(THardwareException)
{
    int Result;
    int Data, Q, X;

    // Z //
    Result = cam_single_cc(_Device, 25, 0, 17, &Data, &Q, &X);
    if (Result) {
	throw THardwareException(
	    "TCamacController_Toyo_CCNET::Initialize()",
	    "error on cam_single_cc()"
        );
    }

    // C //
    Result = cam_single_cc(_Device, 25, 0, 16, &Data, &Q, &X);
    if (Result) {
	throw THardwareException(
	    "TCamacController_Toyo_CCNET::Initialize()",
	    "error on cam_single_cc()"
        );
    }

    return 0;
}

int TCamacController_Toyo_CCNET::Finalize(void) throw(THardwareException)
{
    return 0;
}

int TCamacController_Toyo_CCNET::Clear(void) throw(THardwareException)
{
    int Result;
    int Data, Q, X;

    Result = cam_single_cc(_Device, 25, 0, 16, &Data, &Q, &X);
    if (Result) {
	throw THardwareException(
	    "TCamacController_Toyo_CCNET::Clear()",
	    "error on cam_single_cc()"
        );
    }

    return 0;
}

int TCamacController_Toyo_CCNET::SetInhibit(void) throw(THardwareException)
{
    int Result;
    int Data, Q, X;

    Result = cam_single_cc(_Device, 25, 0, 26, &Data, &Q, &X);
    if (Result) {
	throw THardwareException(
	    "TCamacController_Toyo_CCNET::SetInhibit()",
	    "error on cam_single_cc()"
        );
    }

    return 0;
}

int TCamacController_Toyo_CCNET::ReleaseInhibit(void) throw(THardwareException)
{
    int Result;
    int Data, Q, X;

    Result = cam_single_cc(_Device, 25, 0, 24, &Data, &Q, &X);
    if (Result) {
	throw THardwareException(
	    "TCamacController_Toyo_CCNET::ReleaseInhibit()",
	    "error on cam_single_cc()"
        );
    }

    return 0;
}

int TCamacController_Toyo_CCNET::Transact(int StationNumber, int Function, int Address, int &Data, int &Q, int &X) throw(THardwareException)
{
    int Result;

    Result = cam_single_cc(
	_Device, StationNumber, Address, Function, &Data, &Q, &X
    );
    if (Result) {
	throw THardwareException(
	    "TCamacController_Toyo_CCNET::Transact()",
	    "error on cam_single_cc()"
        );
    }

    return 0;
}

int TCamacController_Toyo_CCNET::ReadLam(int LamMask) throw(THardwareException)
{
    static const int fnTestLam = 8;

    int LamPattern = 0;
    int StationBit, Data, Q, X;
    for (int Station = 1; StationBit < 24; Station++) {
	StationBit = Bit(Station);
	if (StationBit & LamMask) {
	    Transact(Station, fnTestLam, 0, Data, Q, X);
	    if (Q) {
		LamPattern |= StationBit;
	    }
	}
    }

    return LamPattern;
}

int TCamacController_Toyo_CCNET::WaitLam(int TimeOut) throw(THardwareException)
{
    int Result;
    int LamPattern;
    
    EnableInterruptNotification();
    Result = cam_wait_lam(_Device, &LamPattern, TimeOut=100);
    DisableInterruptNotification();

    if (Result) {
	if (Result == ETIME) {
	    return 0;
	}
	throw THardwareException(
	    "TCamacController_Toyo_CCNET::WaitLam()",
	    "error on cam_wait_lam(): " + string(strerror(errno))

        );
    }

    return LamPattern;
}
