/* module-CAEN_V775.hh */
/* Created by Enomoto Sanshiro on 24 April 2005 */
/* Last updated by Enomoto Sanshiro on 9 November 2005. */


#ifndef __module_CAEN_V775_hh__
#define __module_CAEN_V775_hh__


#include "RoomModule.hh"
#include "RoomVmeAccess.hh"


class TVmeTDC_CAEN_V775: public TRoomVmeModule {
  public:
    TVmeTDC_CAEN_V775(int NumberOfChannels);
    virtual ~TVmeTDC_CAEN_V775(void);
    virtual TRoomVmeModule* Clone(void);
  public:
    virtual bool Probe(void) throw(THardwareException);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Finalize(int FinalState = 0) throw(THardwareException);
    virtual int Enable(int Address = -1) throw(THardwareException);
    virtual int Disable(int Address = -1) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual bool WaitData(unsigned TimeOut_sec) throw(THardwareException);
    virtual bool HasData(int Address) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int NextDataBlockSize(int Address = -1) throw(THardwareException);
    virtual int BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException);
    virtual int WriteRegister(int Address, int Data) throw(THardwareException);
    virtual int ReadRegister(int Address, int& Data) throw(THardwareException);
    virtual int EnableInterrupt(int SignalId) throw(THardwareException);
    virtual int DisableInterrupt(void) throw(THardwareException);
    virtual int ClearInterrupt(void) throw(THardwareException);
    virtual void EnableServiceRequest(void) throw(THardwareException);
    virtual void DisableServiceRequest(void) throw(THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
    virtual bool IsRequestingService(void) throw(THardwareException);
    virtual bool IsSignalOnServiceRequestAvailable(void);
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
    virtual int NumberOfChannels(void) throw(THardwareException);
    virtual int AddressBitLength(void);
    virtual int DataBitLength(void);
  protected:
    int SetThreshold(int* ArgumentList, int NumberOfArguments) throw (THardwareException);
    int SetEventTrigger(int* ArgumentList, int NumberOfArguments) throw (THardwareException);
    int SetFastClearWindow(int* ArgumentList, int NumberOfArguments) throw (THardwareException);
    int SetFullScaleRange(int* ArgumentList, int NumberOfArguments) throw (THardwareException);
  private:
    int _NumberOfChannels, _AddressBitLength;
    int _InterruptLevel, _InterruptVector, _EventTriggerThreshold;
    bool _IsEventTriggerSet;
    U32bit* _SingleReadBuffer;
    int _NumberOfSingleReadWords;
    unsigned long _SingleReadFlags;
    int _EventCounterValue;
  private:
    enum TContolId {
	ControlId_ReadEventCounter,
	ControlId_ReadEventCounterOfThisRead,
	ControlId_ResetEventCounter,
	ControlId_SetThreshold,
	ControlId_SetEventTrigger,
	ControlId_SetFastClearWindow,
	ControlId_SetFullScaleRange,
	ControlId_SelectCommonStartMode,
	ControlId_SelectCommonStopMode,
	ControlId_EnableZeroSuppression,
	ControlId_DisableZeroSuppression,
	ControlId_EnableOverflowSuppression,
	ControlId_DisableOverflowSuppression,
	ControlId_EnableNotValidDataSuppression,
	ControlId_DisableNotValidDataSuppression,
	ControlId_EnableEmptyEventRecording,
	ControlId_DisableEmptyEventRecording,
	_NumberOfControls
    };
    enum TModuleParameter {
	_TransferMode = VmeTransferMode_A32D16,
	_MapSize = 0x10000,
	_DataBitLength = 12,
	_MaxNumberOfEvents = 32,
	_EventBufferSize = 32 * 34 * sizeof(U32bit),
	_NumberOfModuleParameters
    };
    enum TRegister {
	regFirmwareRevision = 0x1000,
	regGeoAddress = 0x1002,
	regBitSet1 = 0x1006,
	regBitClear1 = 0x1008,
	regInterruptLevel = 0x100a,
	regInterruptVector = 0x100c,
	regStatus1 = 0x100e,
	regControl1 = 0x1010,
	regAddressDecoderHigh = 0x1012,
	regAddressDecoderLow = 0x1014,
	regEventTrigger = 0x1020,
	regStatus2 = 0x1022,
	regEventCounterLow = 0x1024,
	regEventCounterHigh = 0x1026,
	regIncrementEvent = 0x1028,
	regIncrementOffset = 0x102a,
	regFastClearWindow = 0x102e,
	regBitSet2 = 0x1032,
	regBitClear2 = 0x1034,
	regCrateSelect = 0x103c,
	regEventCounterReset = 0x1040,
	regFullScaleRange = 0x1060,
	regThresholdBase = 0x1080,
	regBoardIdMSB = 0x8036,
	regBoardId = 0x803a,
	regBoardIdLSB = 0x803e,
	_NumberOfRegisters
    };
    enum TControlStatusBit {
	// Bit Set 1 / Bit Clear 1//
	bitBusErrorFlag = (0x0001 << 3),
	bitSelectAddress = (0x0001 << 4),
	bitSoftwareReset = (0x0001 << 7),
	// Status Register 1 //
	bitDataReady = (0x0001 << 0),
	bitGlobalDataReady = (0x0001 << 1),
	bitBusy = (0x0001 << 2),
	bitGlobalBusy = (0x0001 << 3),
	bitTerminationOn = (0x0001 << 6),
	bitTerminationOff = (0x0001 << 7),
	bitEventReady = (0x0001 << 8),
	// Control Register 1 //
	bitBlockEnd = (0x0001 << 2),
	bitResetMode = (0x0001 << 4),
	bitBusErrorEnable = (0x0001 << 5),
	bitAlign64 = (0x0001 << 6),
	// Status Register 2 //
	bitBufferEmpty = (0x0001 << 1),
	bitBufferFull = (0x0001 << 2),
	// Bit Set 2 / Bit Clear 2 //
	bitOffline = (0x0001 << 1),
	bitClearData = (0x0001 << 2),
	bitOverRangeEnable = (0x0001 << 3),
	bitLowThresholdEnable = (0x0001 << 4),
	bitValidControl = (0x0001 << 5),
	bitSlideEnable = (0x0001 << 7),
	bitThresholdStep = (0x0001 << 8),
	bitStartStop = (0x0001 << 10),
	bitAutoIncrementEnable = (0x0001 << 11),
	bitEmptyEnable = (0x0001 << 12),
	bitAllTrigger = (0x0001 << 14),
	// Threshold Register //
	bitKill = (0x0001 << 8),
	_NumberOfControlStatusBits
    };
};


#endif
