/* module-CAEN_V830.hh */
/* Created by Enomoto Sanshiro on 22 December 2005 */
/* Last updated by Enomoto Sanshiro on 28 December 2005. */


#ifndef __module_CAEN_V830_hh__
#define __module_CAEN_V830_hh__


#include "RoomModule.hh"
#include "RoomVmeAccess.hh"


class TVmeScaler_CAEN_V830: public TRoomVmeModule {
  public:
    TVmeScaler_CAEN_V830(int ModelNumber);
    virtual ~TVmeScaler_CAEN_V830(void);
    virtual TRoomVmeModule* Clone(void);
  public:
    virtual bool Probe(void) throw(THardwareException);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Finalize(int FinalState = 0) throw(THardwareException);
    virtual int Enable(int Address = -1) throw(THardwareException);
    virtual int Disable(int Address = -1) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual bool WaitData(unsigned TimeOut_sec) throw(THardwareException);
    virtual bool HasData(int Address) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int NextDataBlockSize(int Address = -1) throw(THardwareException);
    virtual int BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException);
    virtual int WriteRegister(int Address, int Data) throw(THardwareException);
    virtual int ReadRegister(int Address, int& Data) throw(THardwareException);
    virtual int EnableInterrupt(int SignalId) throw(THardwareException);
    virtual int DisableInterrupt(void) throw(THardwareException);
    virtual int ClearInterrupt(void) throw(THardwareException);
    virtual void EnableServiceRequest(void) throw(THardwareException);
    virtual void DisableServiceRequest(void) throw(THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
    virtual bool IsRequestingService(void) throw(THardwareException);
    virtual bool IsSignalOnServiceRequestAvailable(void);
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
    virtual int NumberOfChannels(void) throw(THardwareException);
    virtual int AddressBitLength(void);
    virtual int DataBitLength(void);
  protected:
    virtual int SetDwellTime(int* ArgumentList, int NumberOfArguments) throw (THardwareException);
    inline U32bit GetNextDataWord(void);
  private:
    int _ModelNumber;
    bool _IsHeaderEnabled;
    bool _Is32bitFormatSelected;
    bool _IsDirectReadSelected;
    U32bit _EnabledChannelBitList;
    U32bit _SingleReadFlags;
    U32bit _HeaderValue;
    U32bit* _SingleReadBuffer;
    int _InterruptLevel, _InterruptVector;
    U32bit* _LocalBuffer;
    int _AlmostFullLevel, _NumberOfLocalBufferWords;
  public:
    enum TModelNumber {
	Model_V820,
	Model_V830,
	_NumberOfModels
    };
  private:
    enum TContolId {
	ControlId_Start,
	ControlId_StartPeriodical,
	ControlId_Stop,
	ControlId_Trigger,
	ControlId_SetDwellTime,
	ControlId_EnableHeader,
	ControlId_DisableHeader,
	ControlId_Select32bitFormat,
	ControlId_Select26bitFormat,
	ControlId_SelectDirectRead,
	ControlId_SelectBufferedRead,
	_NumberOfControls
    };
    enum TModuleParameter {
	_TransferMode = VmeTransferMode_A32D32,
	_MapSize = 0x10000,
	_AddressBitLength = 5,
	_DataBitLength = 32,
	_NumberOfChannels = 32,
	_EventBufferSize = 32 * 1024,
	_BufferWindowSize = 0x1000,
	_NumberOfModuleParameters
    };
    enum TRegister {
	regEventBuffer = 0x0000,
	regCounterBase = 0x1000,
	regTestreg = 0x1080,
	regTestlcnth = 0x1094,
	regTesthcntl = 0x10a0,
	regTesthcnth = 0x10a4,
	regChannelEnable = 0x1100,
	regDwellTime = 0x1104,
	regControl = 0x1108,
	regBitSet = 0x110a,
	regBitClear = 0x110c,
	regStatus = 0x110e,
	regInterruptLevel = 0x1112,
	regInterruptVector = 0x1114,
	regADER32 = 0x1116,
	regADER24 = 0x1118,
	regEnableADER = 0x111a,
	regModuleReset = 0x1120,
	regSoftwareClear = 0x1122,
	regSoftwareTrigger = 0x1124,
	regTriggerCounter = 0x1128,
	regAlmostFullLevel = 0x112c,
	regEventNumber = 0x1134,
	regFirmware = 0x1132,
	regBoardIdMSB = 0x4036,
	regBoardId = 0x403a,
	regBoardIdLSB = 0x403e,
	_NumberOfRegisters
    };
    enum TControlStatusBit {
	// Control Register //
	bitAcqMode_Disabled = (0x0000 << 0),
	bitAcqMode_Random = (0x0001 << 0),
	bitAcqMode_Periodical = (0x0002 << 0),
	bitDataFormat_32bit = (0x0000 << 2),
	bitDataFormat_26bit = (0x0001 << 2),
	bitTestMode = (0x0001 << 3),
	bitBerrEnable = (0x0001 << 4),
	bitHeaderEnable = (0x0001 << 5),
	bitClearBuffer = (0x0001 << 6),
	bitAutoReset = (0x0001 << 7),
	// Status Register //
	bitDataReady = (0x0001 << 0),
	bitAlmostFull = (0x0001 << 1),
	bitFull = (0x0001 << 2),
	bitGlobalDataReady = (0x0001 << 3),
	bitGlobalBusy = (0x0001 << 4),
	bitTerminationOn = (0x0001 << 5),
	bitTerminationOff = (0x0001 << 6),
	bitBusErrorFlag = (0x0001 << 7),
	_NumberOfControlStatusBits
    };
};


inline U32bit TVmeScaler_CAEN_V830::GetNextDataWord(void)
{
    if (_NumberOfLocalBufferWords > 0) {
	return _LocalBuffer[_AlmostFullLevel - _NumberOfLocalBufferWords--];
    }

    if (WordAt(regStatus) & bitAlmostFull) {
	DmaRead(regEventBuffer, _LocalBuffer, _BufferWindowSize);
	_NumberOfLocalBufferWords = _AlmostFullLevel;
	return _LocalBuffer[_AlmostFullLevel - _NumberOfLocalBufferWords--];
    }

    return DoubleWordAt(regEventBuffer);
}

#endif
