/* module-Hoshin_V004.hh */
/* Created by Enomoto Sanshiro on 26 May 1997. */
/* Last updated by Enomoto Sanshiro on 20 October 2005. */


#ifndef __module_Hoshin_V004_hh__
#define __module_Hoshin_V004_hh__


#include "RoomModule.hh"
#include "RoomVmeAccess.hh"


/* VME 150MHz 8ch Scaler Model V004 (Hoshin) */
class TVmeScaler_Hoshin_V004: public TRoomVmeModule {
  public:
    TVmeScaler_Hoshin_V004(void);
    virtual ~TVmeScaler_Hoshin_V004();
    virtual TRoomVmeModule* Clone(void);
  public:
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Read(int Address, int& Data) throw(THardwareException);
    virtual int Enable(int Address = -1) throw(THardwareException);
    virtual int Disable(int Address = -1) throw(THardwareException);
    virtual int Clear(int Address= -1) throw(THardwareException);
    virtual int NumberOfChannels(void) throw(THardwareException);
  private:
    enum TV004Parameters {
	V004_MemorySize = 0x1000,
	V004_TransferMode = VmeTransferMode_A24D16,
	V004_NumberOfChannels = 8,
	V004_NumberOfValidBits = 27,
	V004_ValidBitMask = (0x0001 << V004_NumberOfValidBits) - 1,
	_NumberOfParameters
    };
    enum TV004Symbols {
	regStart = 0x00000002,
	regStop = 0x00000004,
	regReset = 0x00000008,
	_NumberOfRegisters
    };
};


#endif
