/* module-Hoshin_V004_OLD.cc */
/* Created by Enomoto Sanshiro on 26 May 1997. */
/* Last updated by Enomoto Sanshiro on 26 December 2001. */


#include "RoomDeviceFactory.hh"
#include "RoomModule.hh"
#include "RoomVmeAccess.hh"
#include "module-Hoshin_V004_OLD.hh"

using namespace std;


static TRoomVmeModuleCreator Creator3(
    "Hoshin_V004_OLD", new TVmeScaler_Hoshin_V004_OLD()
);


TVmeScaler_Hoshin_V004_OLD::TVmeScaler_Hoshin_V004_OLD(void)
: TRoomVmeModule("VmeScaler", "Hoshin_V004_OLD", (TRoomVmeTransferMode) V004_TransferMode, (size_t) V004_MemorySize)
{
    _DataArea = 0;
}

TVmeScaler_Hoshin_V004_OLD::~TVmeScaler_Hoshin_V004_OLD()
{
}

TRoomVmeModule* TVmeScaler_Hoshin_V004_OLD::Clone(void)
{
    return new TVmeScaler_Hoshin_V004_OLD();
}

int TVmeScaler_Hoshin_V004_OLD::Initialize(int InitialState) throw(THardwareException)
{
    _DataArea = DoubleWordPointer();
    Disable();
    Clear();

    return 0;
}

int TVmeScaler_Hoshin_V004_OLD::Read(int Address, int &Data) throw(THardwareException)
{
    Data = _DataArea[Address] & V004_ValidBitMask;

    return 1;
}

int TVmeScaler_Hoshin_V004_OLD::Enable(int Address) throw(THardwareException)
{
    _DataArea[regControl] = bitStart; 

    return 0;
}

int TVmeScaler_Hoshin_V004_OLD::Disable(int Address) throw(THardwareException)
{
    _DataArea[regControl] = bitStop; 
    
    return 0;
}

int TVmeScaler_Hoshin_V004_OLD::Clear(int Address) throw(THardwareException)
{
    _DataArea[regControl] = bitReset; 
    
    return 0;
}

int TVmeScaler_Hoshin_V004_OLD::NumberOfChannels(void) throw(THardwareException)
{
    return V004_NumberOfChannels;
}
