/* module-Hoshin_V004_OLD.hh */
/* Created by Enomoto Sanshiro on 26 May 1997. */
/* Last updated by Enomoto Sanshiro on 26 December 2001. */


#ifndef __module_Hoshin_V004_OLD_hh__
#define __module_Hoshin_V004_OLD_hh__


#include "RoomModule.hh"
#include "RoomVmeAccess.hh"


/* VME 150MHz 8ch Scaler Model V004_OLD (Hoshin) */
class TVmeScaler_Hoshin_V004_OLD: public TRoomVmeModule {
  public:
    TVmeScaler_Hoshin_V004_OLD(void);
    virtual ~TVmeScaler_Hoshin_V004_OLD();
    virtual TRoomVmeModule* Clone(void);
  public:
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Read(int Address, int& Data) throw(THardwareException);
    virtual int Enable(int Address = -1) throw(THardwareException);
    virtual int Disable(int Address = -1) throw(THardwareException);
    virtual int Clear(int Address= -1) throw(THardwareException);
    virtual int NumberOfChannels(void) throw(THardwareException);
  protected:
    volatile DoubleWord* _DataArea;
  private:
    enum TV004Parameters {
	V004_MemorySize = 0x1000,
	V004_TransferMode = VmeTransferMode_A24D32,
	V004_NumberOfChannels = 8,
	V004_NumberOfValidBits = 29,
	V004_ValidBitMask = (0x0001 << V004_NumberOfValidBits) - 1,
	_NumberOfParameters
    };
    enum TV004Symbols {
	regControl = 0x00000000,
	_NumberOfRegisters
    };
    enum TV004ControlBits {
	bitStart = 0x00000100,
	bitStop  = 0x00000200,
	bitReset = 0x00000400,
	_NumberOfControlBits
    };
};


#endif
