/* module-LeCroy_1976.hh */
/* Created by Enomoto Sanshiro on 5 December 2005 */
/* Last updated by Enomoto Sanshiro on 9 December 2005 */


#ifndef __module_LeCroy_1976_hh__
#define __module_LeCroy_1976_hh__


#include "RoomModule.hh"
#include "RoomVmeAccess.hh"


class TCamacAdcTdcTester_LeCroy_1976: public TRoomCamacModule {
  public:
    TCamacAdcTdcTester_LeCroy_1976(void);
    virtual ~TCamacAdcTdcTester_LeCroy_1976();
    virtual TRoomCamacModule* Clone(void);
  public:
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Finalize(int FinalState = 0) throw(THardwareException);
    virtual int Read(int Address, int& Data) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
  protected:
    int SetChargeFullScale(int* ArgumentList, int NumberOfArguments) throw (THardwareException);
    int SetTimeFullScale(int* ArgumentList, int NumberOfArguments) throw (THardwareException);
    int SetAmplitude(int* ArgumentList, int NumberOfArguments) throw (THardwareException);
    int SetGateWidth(int* ArgumentList, int NumberOfArguments) throw (THardwareException);
    int Execute(int* ArgumentList, int NumberOfArguments) throw (THardwareException);
  private:
    enum TRPV160_ContolId {
	ControlId_SelectChargeMode,
	ControlId_SelectTimeMode,
	ControlId_SetChargeFullScale,
	ControlId_SetTimeFullScale,
	ControlId_SetAmplitude,
	ControlId_SetGateWidth,
	ControlId_SelectShortPulse,
	ControlId_SelectLongPulse,
	ControlId_SelectFastTail,
	ControlId_SelectSlowTail,
	ControlId_Execute,
	_NumberOfControls
    };
  private:
    int _Mode;
    int _ChargeFullScale, _ChargeFullScale_pC;
    int _TimeFullScale, _TimeFullScale_nsec;
    int _GateWidthFraction, _GateWidth_nsec;
    int _PulseWidth, _PulseWidth_nsec;
    int _TailFallTime;
    int _Amplitude;
    double _ChargeScaling, _TimeScaling;
    enum TMode {
	Mode_Charge,
	Mode_Time,
	_NumberOfModes
    };
};


#endif
