/* module-Rinei_RPV130.cc */
/* Created by Enomoto Sanshiro on 26 May 1997. */
/* Last updated by Enomoto Sanshiro on 29 December 2002. */


#include "RoomDeviceFactory.hh"
#include "RoomModule.hh"
#include "RoomVmeAccess.hh"
#include "module-Rinei_RPV130.hh"

using namespace std;


static TRoomVmeModuleCreator Creator(
    "Rinei_RPV130", new TVmeIORegister_Rinei_RPV130()
);



TVmeIORegister_Rinei_RPV130::TVmeIORegister_Rinei_RPV130(void)
: TRoomVmeModule("VmeIORegister", "Rinei_RPV130", (TRoomVmeTransferMode) RPV130_TransferMode, (size_t) RPV130_MemorySize)
{
    _EnabledChannelBits = 0;
}

TVmeIORegister_Rinei_RPV130::~TVmeIORegister_Rinei_RPV130()
{
}

TRoomVmeModule* TVmeIORegister_Rinei_RPV130::Clone(void)
{
    return new TVmeIORegister_Rinei_RPV130();
}

int TVmeIORegister_Rinei_RPV130::Initialize(int InitialState) throw(THardwareException)
{
    // interrupt channels must be Enable()-ed explicitly //

    Disable();
    Clear();

    return 0;
}

int TVmeIORegister_Rinei_RPV130::Finalize(int FinalState) throw(THardwareException)
{
    Disable();

    return 0;
}

int TVmeIORegister_Rinei_RPV130::Enable(int Address) throw(THardwareException)
{
    if ((Address == 1) || (Address < 0)){
	WordAt(regCSR1) |= bitEnable12;
	_EnabledChannelBits |= Bit(1);
    }
    if ((Address == 2) || (Address < 0)){
	WordAt(regCSR2) |= bitEnable12;
	_EnabledChannelBits |= Bit(2);
    }
    if ((Address == 3) || (Address < 0)){
	WordAt(regCSR1) |= bitEnable3;
	_EnabledChannelBits |= Bit(3);
    }

    return 0;
}

int TVmeIORegister_Rinei_RPV130::Disable(int Address) throw(THardwareException)
{
    if ((Address == 1) || (Address < 0)){
	WordAt(regCSR1) &= (Word) ~bitEnable12;
	_EnabledChannelBits &= ~Bit(1);
    }
    if ((Address == 2) || (Address < 0)){
	WordAt(regCSR2) &= (Word) ~bitEnable12;
	_EnabledChannelBits &= ~Bit(2);
    }
    if ((Address == 3) || (Address < 0)){
	WordAt(regCSR1) &= (Word) ~bitEnable3;
	_EnabledChannelBits &= ~Bit(3);
    }

    return 0;
}

int TVmeIORegister_Rinei_RPV130::IsEnabled(int Address) throw(THardwareException)
{
    int Result = 0;

    if ((Address == 1) || (Address < 0)) {
	Result |= WordAt(regCSR1) & bitEnable12;	
    }
    if ((Address == 2) || (Address < 0)) {
	Result |= WordAt(regCSR2) & bitEnable12;
    }
    if ((Address == 3) || (Address < 0)) {
	Result |= WordAt(regCSR1) & bitEnable3;
    }

    return Result;
}

int TVmeIORegister_Rinei_RPV130::IsBusy(int Address) throw(THardwareException)
{
    int Csr1 = WordAt(regCSR1);

    if (((Address == 1) || (Address < 0)) && (Csr1 & bitBusy12)) {
	return 1;
    }

    if (((Address == 3) || (Address < 0)) && (Csr1 & bitBusy3)) {
	return 1;
    }

    int Csr2 = WordAt(regCSR2);

    if (((Address == 2) || (Address < 0)) && (Csr2 & bitBusy12)) {
	return 1;
    }

    return 0;
}

int TVmeIORegister_Rinei_RPV130::Clear(int Address) throw(THardwareException)
{
    if ((Address == 1) || (Address < 0)){
	WordAt(regCSR1) |= bitClear12;
    }
    if ((Address == 2) || (Address < 0)){
	WordAt(regCSR2) |= bitClear12;
    }
    if ((Address == 3) || (Address < 0)){
	WordAt(regCSR1) |= bitClear3;
    }

    return 0;
}

int TVmeIORegister_Rinei_RPV130::WriteRegister(int Address, int Data) throw(THardwareException)
{
    WordAt(Address) = Data;
    return 1;
}

int TVmeIORegister_Rinei_RPV130::ReadRegister(int Address, int& Data) throw(THardwareException)
{
    Data = WordAt(Address);
    return 1;
}

int TVmeIORegister_Rinei_RPV130::EnableInterrupt(int SignalId) throw(THardwareException)
{
    return TRoomVmeModule::EnableInterrupt(SignalId);
}

int TVmeIORegister_Rinei_RPV130::DisableInterrupt(void) throw(THardwareException)
{
    return TRoomVmeModule::DisableInterrupt();
}

int TVmeIORegister_Rinei_RPV130::ClearInterrupt(void) throw(THardwareException)
{
    return Clear();
}

bool TVmeIORegister_Rinei_RPV130::HasData(int Address) throw(THardwareException)
{
    if (Address < 0) {
	return HasData(1) || HasData(2) || HasData(3);
    }
    else {
	return (_EnabledChannelBits & Bit(Address)) && IsBusy(Address);
    }
}

bool TVmeIORegister_Rinei_RPV130::WaitData(unsigned TimeOut_sec) throw(THardwareException)
{
    TRoomVmeModule::WaitData(TimeOut_sec);
    return HasData();
}

void TVmeIORegister_Rinei_RPV130::EnableServiceRequest(void) throw(THardwareException)
{
    // channels must be explicitly specified by calling enable().
}

void TVmeIORegister_Rinei_RPV130::DisableServiceRequest(void) throw(THardwareException)
{
    Disable();
}

void TVmeIORegister_Rinei_RPV130::ClearServiceRequest(void) throw(THardwareException)
{
    Clear();
}

bool TVmeIORegister_Rinei_RPV130::IsRequestingService(void) throw(THardwareException)
{
    return HasData();
}

int TVmeIORegister_Rinei_RPV130::RequestingServiceNumber(void) throw(THardwareException)
{
    return 0;
}

void TVmeIORegister_Rinei_RPV130::EnableSignalOnServiceRequest(int SignalId) throw(THardwareException)
{
    EnableInterrupt(SignalId);
}

void TVmeIORegister_Rinei_RPV130::DisableSignalOnServiceRequest(void) throw(THardwareException)
{
    DisableInterrupt();
}

int TVmeIORegister_Rinei_RPV130::MiscControlIdOf(const std::string& CommandName) throw (THardwareException)
{
    int ControlId = -1;

    if (CommandName == "inputLatch1") {
	ControlId = ControlId_InputLatch1;
    }
    else if (CommandName == "inputLatch2") {
	ControlId = ControlId_InputLatch2;
    }
    else if (CommandName == "inputFlipFlop") {
	ControlId = ControlId_InputFlipFlop;
    }
    else if (CommandName == "inputThrough") {
	ControlId = ControlId_InputThrough;
    }
    else if (CommandName == "outputLevel") {
	ControlId = ControlId_OutputLevel;
    }
    else if (CommandName == "outputPulse") {
	ControlId = ControlId_OutputPulse;
    }
    else {
	throw THardwareException(
	    _ModelName, "unknown command: " + CommandName
	);
    }

    return ControlId;
}

int TVmeIORegister_Rinei_RPV130::MiscControl(int ControlId, int* ArgumentList, int NumberOfArguments) throw (THardwareException)
{
    if (NumberOfArguments < 1) {
	throw THardwareException(
	    _ModelName + "::MiscControl(...)", "too few argument[s]"
	);
    }

    int Result;
    
    switch (ControlId) {
      case ControlId_InputLatch1:
	Result = InputLatch1(ArgumentList[0]);
	break;
      case ControlId_InputLatch2:
	Result = InputLatch2(ArgumentList[0]);
	break;
      case ControlId_InputFlipFlop:
	Result = InputFlipFlop(ArgumentList[0]);
	break;
      case ControlId_InputThrough:
	Result = InputThrough(ArgumentList[0]);
	break;
      case ControlId_OutputLevel:
	Result = OutputLevel(ArgumentList[0]);
	break;
      case ControlId_OutputPulse:
	Result = OutputPulse(ArgumentList[0]);
	break;
      default:
	Result = 0;
    }

    return Result;
}

int TVmeIORegister_Rinei_RPV130::InputLatch1(int& Data) throw(THardwareException)
{
    Data = (WordAt(regInputLatch1) & 0x00ff);
    return 1;
}

int TVmeIORegister_Rinei_RPV130::InputLatch2(int& Data) throw(THardwareException)
{
    Data = (WordAt(regInputLatch2) & 0x00ff);
    return 1;
}

int TVmeIORegister_Rinei_RPV130::InputFlipFlop(int& Data) throw(THardwareException)
{
    Data = (WordAt(regInputFlipFlop) & 0x00ff);
    return 1;
}

int TVmeIORegister_Rinei_RPV130::InputThrough(int& Data) throw(THardwareException)
{
    Data = (WordAt(regInputThrough) & 0x00ff);
    return 1;
}

int TVmeIORegister_Rinei_RPV130::OutputLevel(int Data) throw(THardwareException)
{
    WordAt(regOutputLevel) = Data;
    return 1;
}

int TVmeIORegister_Rinei_RPV130::OutputPulse(int Data) throw(THardwareException)
{
    WordAt(regOutputPulse) = Data;
    return 1;
}
