/* module-Rinei_RPV130.hh */
/* Created by Enomoto Sanshiro on 26 May 1997. */
/* Last updated by Enomoto Sanshiro on 29 December 2002. */


#ifndef __module_Rinei_RPV130_hh__
#define __module_Rinei_RPV130_hh__


#include "RoomModule.hh"
#include "RoomVmeAccess.hh"


/* Interrupt & I/O Register Model RPV-130 (Rinei) */
class TVmeIORegister_Rinei_RPV130: public TRoomVmeModule {
  public:
    TVmeIORegister_Rinei_RPV130(void);
    virtual ~TVmeIORegister_Rinei_RPV130();
    virtual TRoomVmeModule* Clone(void);
  public:
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Finalize(int FinalState = 0) throw(THardwareException);
    virtual int Enable(int Address = -1) throw(THardwareException);
    virtual int Disable(int Address = -1) throw(THardwareException);
    virtual int IsEnabled(int Address = -1) throw(THardwareException);
    virtual int IsBusy(int Address = -1) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int WriteRegister(int Address, int Data) throw(THardwareException);
    virtual int ReadRegister(int Address, int& Data) throw(THardwareException);
    virtual int EnableInterrupt(int SignalId = 0) throw(THardwareException);
    virtual int DisableInterrupt(void) throw(THardwareException);
    virtual int ClearInterrupt(void) throw(THardwareException);
    virtual bool HasData(int Address = -1) throw(THardwareException);
    virtual bool WaitData(unsigned TimeOut_sec) throw(THardwareException);
  public:
    virtual void EnableServiceRequest(void) throw(THardwareException);
    virtual void DisableServiceRequest(void) throw(THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
    virtual bool IsRequestingService(void) throw(THardwareException);
    virtual int RequestingServiceNumber(void) throw(THardwareException);
    virtual void EnableSignalOnServiceRequest(int SignalId) throw(THardwareException);
    virtual void DisableSignalOnServiceRequest(void) throw(THardwareException);
  public:
    virtual int MiscControlIdOf(const std::string& CommandName) throw(THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
    int InputLatch1(int& Data) throw(THardwareException);
    int InputLatch2(int& Data) throw(THardwareException);
    int InputFlipFlop(int& Data) throw(THardwareException);
    int InputThrough(int& Data) throw(THardwareException);
    int OutputLevel(int Data) throw(THardwareException);
    int OutputPulse(int Data) throw(THardwareException);
  public:
    enum TControlId {
	ControlId_InputLatch1,
	ControlId_InputLatch2,
	ControlId_InputFlipFlop,
	ControlId_InputThrough,
	ControlId_OutputLevel,
	ControlId_OutputPulse,
	_NumberOfControls
    };
  private:
    enum TRPV130Parameters {
	RPV130_MemorySize = 0x1000,
	RPV130_TransferMode = VmeTransferMode_A16D16
    };
    enum TRPV130Symbols {
	regInputLatch1 = 0x0000,
	regInputLatch2 = 0x0002,
	regInputFlipFlop = 0x0004,
	regInputThrough = 0x0006,
	regOutputPulse = 0x0008,
	regOutputLevel = 0x000a,
	regCSR1 = 0x000c,
	regCSR2 = 0x000e,
	    bitBusy3 = 0x80,
	    bitEnable3 = 0x40,
	    bitBusy12 = 0x20,
	    bitEnable12 = 0x10,
	    bitMask12 = 0x08,
	    bitClear12 = 0x02,
	    bitClear3 = 0x01
    };
  private:
    int _EnabledChannelBits;
};


#endif
