/* module-Rinei_RPV170.cc */
/* Created by Enomoto Sanshiro on 29 July 2003. */
/* Last updated by Enomoto Sanshiro on 29 July 2003. */


#include "RoomDeviceFactory.hh"
#include "RoomVmeAccess.hh"
#include "module-Rinei_RPV170.hh"

using namespace std;


static TRoomVmeModuleCreator Creator("Rinei_RPV170", new TVmeQADC_Rinei_RPV170());


TVmeQADC_Rinei_RPV170::TVmeQADC_Rinei_RPV170(void)
: TRoomVmeModule("VmeQADC", "Rinei_RPV170", (TRoomVmeTransferMode) RPV170_TransferMode, (size_t) RPV170_MapSize)
{
}

TVmeQADC_Rinei_RPV170::~TVmeQADC_Rinei_RPV170()
{
}

TRoomVmeModule* TVmeQADC_Rinei_RPV170::Clone(void)
{
    return new TVmeQADC_Rinei_RPV170();
}

int TVmeQADC_Rinei_RPV170::Initialize(int InitialState) throw(THardwareException)
{
    /* initialize channels */
    for (int Channel = 0; Channel < RPV170_NumberOfChannels; Channel++) {
        U32bit VmeAddress = 0x21002 + 0x200 * Channel;
	static const U16bit Data = 0x0080;
	PioWrite(VmeAddress, &Data, sizeof(Data));
    }

    Clear();
    
    return 1;
}

int TVmeQADC_Rinei_RPV170::Finalize(int FinalState) throw(THardwareException)
{
    return 1;
}

int TVmeQADC_Rinei_RPV170::Clear(int Address) throw(THardwareException)
{
    static const U32bit VmeAddress = regClear;
    static const U16bit Data = bitClear_CLR;
    PioWrite(VmeAddress, &Data, sizeof(Data));

    return 1;
}

bool TVmeQADC_Rinei_RPV170::HasData(int Address) throw(THardwareException)
{
    static const U32bit VmeAddress = regFlag;
    static U16bit Data;
    PioRead(VmeAddress, &Data, sizeof(Data));

    return Data == (bitFlag_HIT | bitFlag_DONE);
}

bool TVmeQADC_Rinei_RPV170::WaitData(unsigned TimeOut_sec) throw(THardwareException)
{
    return TRoomModule::WaitData(TimeOut_sec);
}

int TVmeQADC_Rinei_RPV170::Read(int Address, int &Data) throw(THardwareException)
{
    Data = WordAt((Address & 0x0f) * 2);
    return 1;
}

int TVmeQADC_Rinei_RPV170::NextDataBlockSize(int Address) throw(THardwareException)
{
    return RPV170_DataBlockSize;
}

int TVmeQADC_Rinei_RPV170::BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException)
{
    return PioRead(0, Data, RPV170_DataBlockSize);
}

int TVmeQADC_Rinei_RPV170::NumberOfChannels(void) throw(THardwareException)
{
    return RPV170_NumberOfChannels;
}

int TVmeQADC_Rinei_RPV170::AddressBitLength(void)
{
    return RPV170_AddressBitLength;
}

int TVmeQADC_Rinei_RPV170::DataBitLength(void)
{
    return RPV170_DataBitLength;
}

bool TVmeQADC_Rinei_RPV170::IsSignalOnServiceRequestAvailable(void)
{
    return false;
}

void TVmeQADC_Rinei_RPV170::ClearServiceRequest(void) throw(THardwareException)
{
    Clear();
}



#if 0

// sample KTS script for RPV170 //

datasource RPV170_test
{
    int base_address = 0x01000000;
    int readout_channels = #0..#3;
    
    VmeCrate crate;
    VmeController controller("SBS-620");
    VmeModule adc("Rinei-RPV170");

    crate.installController(controller);
    crate.installModule(adc, base_address);
    
    on trigger(adc) {
        adc.read(readout_channels);
	adc.clear();
    }
}


#endif
