/* module-SIS_3600.cc */
/* Created by Glenn H-S. on 31 Aug 2000. */
/* Last updated by Enomoto Sanshiro on 9 August 2002. */


#include "RoomDeviceFactory.hh"
#include "RoomVmeAccess.hh"
#include "module-SIS_3600.hh"

using namespace std;


static TRoomVmeModuleCreator Creator("SIS_3600", new TVmeLatch_SIS_3600());


TVmeLatch_SIS_3600::TVmeLatch_SIS_3600(void)
: TRoomVmeModule("VmeLatch", "SIS_3600", (TRoomVmeTransferMode) SIS3600_TransferMode, (size_t) SIS3600_MapSize)
{
}

TVmeLatch_SIS_3600::~TVmeLatch_SIS_3600()
{
}

TRoomVmeModule* TVmeLatch_SIS_3600::Clone(void)
{
    return new TVmeLatch_SIS_3600();
}

bool TVmeLatch_SIS_3600::Probe(void) throw(THardwareException)
{
    return (GetDoubleWord(regIdIrq) >> 16) == SIS3600_BoardId;
}

int TVmeLatch_SIS_3600::Initialize(int InitialState) throw(THardwareException)
{
    PutDoubleWord(regReset, 0);
    Clear();

    return 1;
}

int TVmeLatch_SIS_3600::Clear(int Address) throw(THardwareException)
{
    // keep the following order //
    PutDoubleWord(regDisableNextClock, 0);
    PutDoubleWord(regClearFifo, 0);
    PutDoubleWord(regEnableNextClock, 0);
    PutDoubleWord(regCSR, bitExtNextEna);

    // EnableNextClock generates one word of garbage data
    _DummyVariableToAvoidCompilerOptimization = GetDoubleWord(regFifoRead);  

    return 0;
}

int TVmeLatch_SIS_3600::Read(int Address, int &Data) throw(THardwareException)
{
    if ((GetDoubleWord(regCSR) & bitFifoEmpty) == 0) {
	Data = GetDoubleWord(regFifoRead);
	return 1;
    }
    else {
	Data = -1;
	return 0;
    }
}

int TVmeLatch_SIS_3600::NextDataBlockSize(int Address) throw(THardwareException)
{
    return FifoSize; 
}

int TVmeLatch_SIS_3600::BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException)
{
    DoubleWord *Next = (DoubleWord*) Data;
    DoubleWord *End= Next + MaxSize / sizeof(DoubleWord);
    
    bool IsFifoFull = GetDoubleWord(regCSR) & bitFifoFull;

#if 0
    // DMA Read //
    // DMA for this small data block is slower than PIO
    if (GetDoubleWord(regCSR) & (bitFifoHalfFull | bitFifoAlmostFull | bitFifoFull)) {
        int DmaSize = (MaxSize < FifoSize / 2) ? MaxSize : FifoSize / 2;
	int NumberOfDmaRead = DmaSize / FifoWindowSize;
	for (int DmaCount = 0; DmaCount < NumberOfDmaRead; DmaCount++) {
            DmaRead(regFifoStart, dest, FifoWindowSize);
	    Next += FifoWindowSize / sizeof(DoubleWord);
	}
    }
#else
    // PIO Read //
    while ((GetDoubleWord(regCSR) & bitFifoEmpty) == 0 && Next < End) {
	*(Next++) = GetDoubleWord(regFifoRead);
    }
#endif

    if (IsFifoFull) {
        cerr << "SIS-3600 FIFO FULL" << endl;
	PutDoubleWord(regClearFifo, 0);   // reset required to continue
    }

    return (Next - (DoubleWord*) Data) * sizeof(DoubleWord);
}

int TVmeLatch_SIS_3600::ReadRegister(int Address, int& Data) throw(THardwareException)
{
    Data = GetDoubleWord(Address);
    return 1;
}

int TVmeLatch_SIS_3600::WriteRegister(int Address, int Data) throw(THardwareException)
{
    PutDoubleWord(Address, Data);
    return 1;
}
