/* module-SimulatedModules.hh */
/* Created by Enomoto Sanshiro on 23 April 1999. */
/* Last updated by Enomoto Sanshiro on 8 July 2001. */


#ifndef __module_SimulatedModules_hh__
#define __module_SimulatedModules_hh__


#include "RoomDefs.hh"
#include "RoomModule.hh"
#include "RoomSoftwareDevice.hh"


class TPoissonGenerator: public TRoomSoftwareModule {
  public:
    TPoissonGenerator(int NumberOfChannels = 16, int FullScale = 4096);
    virtual ~TPoissonGenerator();
    virtual TRoomSoftwareModule* Clone(void);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int NumberOfChannels(void) throw(THardwareException);
  private:
    int _NumberOfChannels;
    int _FullScale;
    double _Mean;
};


class TGaussianGenerator: public TRoomSoftwareModule {
  public:
    TGaussianGenerator(int NumberOfChannels = 16, int FullScale = 4096);
    virtual ~TGaussianGenerator();
    virtual TRoomSoftwareModule* Clone(void);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int NumberOfChannels(void) throw(THardwareException);
  private:
    int _NumberOfChannels;
    int _FullScale;
    double _Mean, _Deviation;
};


class TExponentialGenerator: public TRoomSoftwareModule {
  public:
    TExponentialGenerator(int NumberOfChannels = 16, int FullScale = 4096);
    virtual ~TExponentialGenerator();
    virtual TRoomSoftwareModule* Clone(void);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int NumberOfChannels(void) throw(THardwareException);
  private:
    int _NumberOfChannels;
    int _FullScale;
    double _Lambda;
};


class TWaveGenerator: public TRoomSoftwareModule {
  public:
    TWaveGenerator(int NumberOfChannels = 16, int NumberOfSamples = 128, int FullScale = 4096);
    virtual ~TWaveGenerator();
    virtual TRoomSoftwareModule* Clone(void);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int NumberOfChannels(void) throw(THardwareException);
    virtual int AddressBitLength(void);
    virtual int ElementDepth(void);
    virtual int NextNumberOfDataElements(int Address = -1) throw(THardwareException);
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
  private:
    int _NumberOfChannels;
    int _NumberOfSamples;
    int *_ReadoutCount;
    int _FullScale;
    double _NoiseLevel;
  public:
    enum TContolId {
        ControlId_SetSamplingDepth,
        ControlId_SetFullScale,
        ControlId_SetNoiseLevel,
	_NumberOfControls
    };
};


class TPmtSimulator: public TRoomSoftwareModule {
  public:
    TPmtSimulator(int FullScale = 4096);
    virtual ~TPmtSimulator();
    virtual TRoomSoftwareModule* Clone(void);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int NumberOfChannels(void) throw(THardwareException);
    virtual int AddressBitLength(void) throw(THardwareException);
    virtual int DataBitLength(void) throw(THardwareException);
  private:
    int _FullScale;
  public:
    enum TContolId {
	ControlId_SetHitRate,
	_NumberOfControls
    };
};


#endif

