/* module-SoftwareModules.hh */
/* Created by Enomoto Sanshiro on 23 April 1999. */
/* Last updated by Enomoto Sanshiro on 5 November 2001. */


#ifndef __module_SoftwareModules_hh__
#define __module_SoftwareModules_hh__


#include "RoomDefs.hh"
#include "RoomModule.hh"
#include "RoomSoftwareDevice.hh"


class TSoftwareModule_IntervalTimer: public TRoomSoftwareModule {
  public:
    TSoftwareModule_IntervalTimer(long Interval_sec, long Interval_usec);
    virtual ~TSoftwareModule_IntervalTimer();
    virtual TRoomSoftwareModule* Clone(void);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual bool HasData(int Address = -1) throw(THardwareException);
    virtual bool WaitData(unsigned TimeOut_sec = 1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int WriteRegister(int Address, int Data) throw(THardwareException);
    virtual int ReadRegister(int Address, int& Data) throw(THardwareException);
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
  protected:
    void SetInterval(int Interval_Sec, int Interval_USec) throw(THardwareException);
    long NumberOfTicks(void);
    long PassedTime(void);
    void Reset(void);
  protected:
    long _Interval_sec, _Interval_usec, _Interval;
    long _StartTime_sec, _StartTime_usec;
    long _LastHandledTick;
    bool _IsRunning;
  private:
    enum TControlId {
	ControlId_SetInterval,
	ControlId_Start,
	ControlId_Stop,
	_NumberOfControls
    };
    enum {
	_MinimumSleepInterval_usec = 10
    };
};


class TSoftwareModule_OneShotTimer: public TRoomSoftwareModule {
  public:
    TSoftwareModule_OneShotTimer(long Interval_sec, long Interval_usec);
    virtual ~TSoftwareModule_OneShotTimer();
    virtual TRoomSoftwareModule* Clone(void);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual bool HasData(int Address = -1) throw(THardwareException);
    virtual bool WaitData(unsigned TimeOut_sec = 1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
  protected:
    void SetInterval(int Interval_Sec, int Interval_USec) throw(THardwareException);
    long PassedTime(void);
  protected:
    long _Interval, _Interval_sec, _Interval_usec;
    long _StartTime_sec, _StartTime_usec;
    bool _IsRunning;
  private:
    enum TControlId {
	ControlId_SetInterval,
	ControlId_Start,
	ControlId_Stop,
	_NumberOfControls
    };
};


class TSoftwareModule_CuckooClock: public TRoomSoftwareModule {
  public:
    TSoftwareModule_CuckooClock(long Interval_sec);
    virtual ~TSoftwareModule_CuckooClock();
    virtual TRoomSoftwareModule* Clone(void);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual bool HasData(int Address = -1) throw(THardwareException);
    virtual bool WaitData(unsigned TimeOut_sec = 1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
  protected:
    void SetInterval(int Interval_Sec) throw(THardwareException);
    long PassedTime(void);
    void Reset(void);
  protected:
    long _Interval;
    long _StartTime;
    bool _IsRunning;
  private:
    enum TControlId {
	ControlId_SetInterval,
	ControlId_Start,
	ControlId_Stop,
	_NumberOfControls
    };
};


class TSoftwareModule_AlarmClock: public TRoomSoftwareModule {
  public:
    TSoftwareModule_AlarmClock(long Interval_sec);
    virtual ~TSoftwareModule_AlarmClock();
    virtual TRoomSoftwareModule* Clone(void);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual bool HasData(int Address = -1) throw(THardwareException);
    virtual bool WaitData(unsigned TimeOut_sec = 1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
  protected:
    void SetInterval(int Interval_Sec) throw(THardwareException);
    long NumberOfTicks(void);
    long PassedTime(void);
    void Reset(void);
  protected:
    long _Interval;
    long _StartTime;
    bool _IsRunning;
  private:
    enum TControlId {
	ControlId_SetInterval,
	ControlId_Start,
	ControlId_Stop,
	_NumberOfControls
    };
};


class TSoftwareModule_Counter: public TRoomSoftwareModule {
  public:
    TSoftwareModule_Counter(int NumberOfChannels = 16, long FullScale = 65536);
    virtual ~TSoftwareModule_Counter();
    virtual TRoomSoftwareModule* Clone(void);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int NumberOfChannels(void) throw(THardwareException);
  private:
    int _NumberOfChannels;
    long _FullScale;
    int *_ReadoutCount;
};


#endif

