/* module-VMIC_5010.hh */
/* Created by Enomoto Sanshiro on 25 July 2001 */
/* Last updated by Enomoto Sanshiro on 25 July 2001. */


#ifndef __module_VMIC_5010_hh__
#define __module_VMIC_5010_hh__


#include "RoomModule.hh"
#include "RoomVmeAccess.hh"



class TVmeInterrupter_VMIC_5010: public TRoomVmeModule {
  public:
    TVmeInterrupter_VMIC_5010(void);
    virtual ~TVmeInterrupter_VMIC_5010();
    virtual TRoomVmeModule* Clone(void);
  public:
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Finalize(int FinalState = 0) throw(THardwareException);
    virtual int Enable(int Address = -1) throw(THardwareException);
    virtual int Disable(int Address = -1) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int IsBusy(int Address = -1) throw(THardwareException);
    virtual int EnableInterrupt(int SignalId = 0) throw(THardwareException);
    virtual int DisableInterrupt(void) throw(THardwareException);
    virtual int ClearInterrupt(void) throw(THardwareException);
  public:
    virtual void EnableServiceRequest(void) throw(THardwareException);
    virtual void DisableServiceRequest(void) throw(THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
    virtual bool IsRequestingService(void) throw(THardwareException);
  private:
    static const off_t ControlRegisterOffset[];
    static const off_t VectorRegisterOffset[];
    bool _IsInterruptSignalUsed;
  private:
    enum TVMIC5010Parameters {
	MapSize_VMIC5010 = 0x1000,
	TransferMode_VMIC5010 = VmeTransferMode_A16D16,
	NumberOfChannels_VMIC5010 = 16
    };
    enum TVMIC5010Registers {
	regPolarityControl = 0x02,
	regFieldInputEnable = 0x04,
	regBoardControl = 0x06,
	regInterruptControl_7 = 0x60,
	regInterruptControl_6 = 0x62,
	regInterruptControl_5 = 0x64,
	regInterruptControl_4 = 0x66,
	regInterruptControl_3 = 0x70,
	regInterruptControl_2 = 0x72,
	regInterruptControl_1 = 0x74,
	regInterruptControl_0 = 0x76,
	regInterruptVector_7 = 0x68,
	regInterruptVector_6 = 0x6a,
	regInterruptVector_5 = 0x6c,
	regInterruptVector_4 = 0x6e,
	regInterruptVector_3 = 0x78,
	regInterruptVector_2 = 0x7a,
	regInterruptVector_1 = 0x7c,
	regInterruptVector_0 = 0x7e,
	regGlobalInterruptControl_7 = 0x40,
	regGlobalInterruptControl_6 = 0x42,
	regGlobalInterruptControl_5 = 0x44,
	regGlobalInterruptControl_4 = 0x46,
	regGlobalInterruptControl_3 = 0x50,
	regGlobalInterruptControl_2 = 0x52,
	regGlobalInterruptControl_1 = 0x54,
	regGlobalInterruptControl_0 = 0x56,
	regGlobalInterruptVector_7 = 0x48,
	regGlobalInterruptVector_6 = 0x4a,
	regGlobalInterruptVector_5 = 0x4c,
	regGlobalInterruptVector_4 = 0x4e,
	regGlobalInterruptVector_3 = 0x58,
	regGlobalInterruptVector_2 = 0x5a,
	regGlobalInterruptVector_1 = 0x5c,
	regGlobalInterruptVector_0 = 0x5e
    };
    enum TVMIC5010ControlBits {
	bitFlag = 0x80,
	bitFlagAutoClear = 0x40,
	bitExternalVector = 0x20,
	bitInterruptEnable = 0x10,
	bitInterruptAutoClear = 0x08
    };
};


#endif
