/* module-VmeModules.cc */
/* Created by Enomoto Sanshiro on 26 May 1997. */
/* Last updated by Enomoto Sanshiro on 5 December 2002. */


#include "RoomDeviceFactory.hh"
#include "RoomModule.hh"
#include "RoomVmeAccess.hh"
#include "module-VmeModules.hh"


static TRoomVmeModuleCreator Creator1(
    "Generic_MemoryA16D16", 
    new TVmeMemory_Generic(VmeTransferMode_A16D16)
);
static TRoomVmeModuleCreator Creator2(
    "Generic_MemoryA16D32", 
    new TVmeMemory_Generic(VmeTransferMode_A16D32)
);
static TRoomVmeModuleCreator Creator3(
    "Generic_MemoryA24D16", 
    new TVmeMemory_Generic(VmeTransferMode_A24D16)
);
static TRoomVmeModuleCreator Creator4(
    "Generic_MemoryA24D32", 
    new TVmeMemory_Generic(VmeTransferMode_A24D32)
);
static TRoomVmeModuleCreator Creator5(
    "Generic_MemoryA32D16", 
    new TVmeMemory_Generic(VmeTransferMode_A32D16)
);
static TRoomVmeModuleCreator Creator6(
    "Generic_MemoryA32D32", 
    new TVmeMemory_Generic(VmeTransferMode_A32D32)
);


TVmeMemory_Generic::TVmeMemory_Generic(TRoomVmeTransferMode TransferMode)
: TRoomVmeModule("VmeMemory", "Generic_VmeMemory", TransferMode)
{
}

TVmeMemory_Generic::~TVmeMemory_Generic()
{
}

TRoomVmeModule* TVmeMemory_Generic::Clone(void)
{
    return new TVmeMemory_Generic(TransferMode());
}
