/* module-VmeSmp.cc */
/* Created by Enomoto Sanshiro on 31 July 1999. */
/* Last updated by Enomoto Sanshiro on 4 November 2001. */


// ******************************************** //
// * THIS CODE IS NOT MAINTAINED. DO NOT USE. * //
// ******************************************** //


#include "RoomDeviceFactory.hh"
#include "RoomModule.hh"
#include "RoomVmeAccess.hh"
#include "RoomTkoAccess.hh"
#include "module-VmeSmp.hh"

using namespace std;


static TRoomVmeModuleCreator Creator("VmeSmp", new TVmeMisc_VmeSmp());


TVmeMisc_VmeSmp::TVmeMisc_VmeSmp(void)
: TRoomVmeModule("VmeMisc", "VmeSmp (NOT TESTED)", (TRoomVmeTransferMode) TransferMode_VmeSmp, (size_t) MapSize_VmeSmp)
{
}

TVmeMisc_VmeSmp::~TVmeMisc_VmeSmp()
{
}

TRoomVmeModule* TVmeMisc_VmeSmp::Clone(void)
{
    return new TVmeMisc_VmeSmp();
}

int TVmeMisc_VmeSmp::Clear(int Address) throw(THardwareException)
{
    // EnableBankSwitch();
    return 1;
}

int TVmeMisc_VmeSmp::NextDataBlockSize(int Address) throw(THardwareException)
{
    return BufferSize;
}

int TVmeMisc_VmeSmp::BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException)
{
    int DataSize = GetDoubleWord(regDataSize);
    if (DataSize & bitBufferOverFlow) {
	Clear();
	return 0;
    }
    
    int Size = DataSize;
    if (Size > MaxSize) {
	Size = MaxSize;
    }
    
    int ReadSize = DmaRead(0, Data, Size);

    return ReadSize;
}

int TVmeMisc_VmeSmp::EnableInterrupt(int SignalId) throw(THardwareException)
{
    return TRoomVmeModule::EnableInterrupt(SignalId);
}

int TVmeMisc_VmeSmp::DisableInterrupt(void) throw(THardwareException)
{
    return TRoomVmeModule::DisableInterrupt();
}

int TVmeMisc_VmeSmp::ClearInterrupt(void) throw(THardwareException)
{
    return TRoomVmeModule::ClearInterrupt();
}

void TVmeMisc_VmeSmp::EnableServiceRequest(void) throw(THardwareException)
{
    int Irq = VmeAccessProperty()->InterruptNumber;
    int Vector = VmeAccessProperty()->InterruptVector;
    int ControlBits = bitInterruptEnable | bitInterruptFlag | bitInterruptFlagAutoClear;

    PutDoubleWord(regInterruptVector, Vector);
    PutDoubleWord(regInterruptControl, ControlBits | Irq);
}

void TVmeMisc_VmeSmp::DisableServiceRequest(void) throw(THardwareException)
{
    PutDoubleWord(regInterruptControl, 0);
}

void TVmeMisc_VmeSmp::ClearServiceRequest(void) throw(THardwareException)
{
    DoubleWordAt(regInterruptControl) |= bitInterruptFlag | bitInterruptFlagAutoClear;
}

bool TVmeMisc_VmeSmp::IsRequestingService(void) throw(THardwareException)
{
    return ((GetDoubleWord(regInterruptControl) & bitInterruptFlag) == 0);
}



TTkoController_VmeSmp::TTkoController_VmeSmp(void)
{
}

TTkoController_VmeSmp::~TTkoController_VmeSmp()
{
}

int TTkoController_VmeSmp::TkoAction(int ModuleAddress, int Address, int Function, int &Data, int &Q) throw(THardwareException)
{
    return Q;
}
