/* vmic-5010-test.cc */
/* Created by Enomoto Sanshiro on 26 July 2001. */


#include <cstdio>
#include <signal.h>
#include "RoomVmeAccess.hh"
#include "RoomDeviceFactory.hh"

using namespace std;

static const int BaseAddress = 0x2000;
static const int Irq = 5;
static const int Vector = 0xff55;


int main(void)
{
    TRoomDeviceFactory* DeviceFactory = TRoomDeviceFactory::GetInstance();

    TRoomVmeController* VmeController = DeviceFactory->CreateVmeController();
    TRoomVmeCrate* VmeCrate = DeviceFactory->CreateVmeCrate();
    TRoomVmeModule* Interrupter = DeviceFactory->CreateVmeModule("VMIC-5010");

    try {
        VmeCrate->InstallController(VmeController);
	VmeCrate->Install(Interrupter, BaseAddress, Irq, Vector);
	
	Interrupter->Initialize();
	Interrupter->Clear(0);
	Interrupter->EnableServiceRequest();

	int WaitStatus;
	for (int i = 0; i < 8; i++) {
	    cout << "waiting interrupt..." << flush;
#if 1
	    //WaitStatus = Interrupter->WaitForServiceRequest();
	    WaitStatus = Interrupter->WaitData(1);
#else
	    Interrupter->EnableSignalOnServiceRequest();
	    (void) getchar();
	    Interrupter->DisableSignalOnServiceRequest();
#endif
	    int IsBusy = Interrupter->IsRequestingService();
	    if (WaitStatus) {
	        cout << "ok." << flush;
		Interrupter->Clear(0);
	    }
	    else {
	        cout << "timed out." << flush;
	    }
	    cout << " (" << IsBusy << ")" << endl;
	}

	Interrupter->DisableServiceRequest();
	Interrupter->Finalize();
    }
    catch (THardwareException &e) {
        cerr << "ERROR: " << e << endl;
    }

    delete Interrupter;
    delete VmeCrate;
    delete VmeController;

    return 0;
}

