/* vui.hh */
/* rewrite of /opt/_RCvme/sys/vui.h to link C++ */
/* Created by Enomoto Sanshiro on 19 June 1998. */
/* Last updated by Enomoto Sanshiro on 19 June 1998. */

#ifndef __vui_hh__
#define __vui_hh__


#define VUI_OK		 0
#define VUI_FAIL	-1

extern "C" {
    int vui_reg_read( int dev, int vmereg, ulong_t *regvalue );
    int vui_reg_write( int dev, int vmereg, ulong_t regvalue );
    int vui_rmw( int dev, vmeaddr_t vmeaddr, ubyte_t *value );
    caddr_t vui_slave_map( int dev, ioctl_map_t *dvma );
    int vui_slave_unmap( int dev, ioctl_map_t *dvma, caddr_t vaddr );
    int vui_mbox_set( int dev, ioctl_mbox_t *mbox );
    int vui_mbox_info( int dev, ioctl_mbox_info_t *mbox );
    int vui_mbox_wait( int dev, int mbox_num ); 
    int vui_mbox_remove( int dev, int mbox_num ); 
    int vui_reg_base_set( int dev, vmeaddr_t regbase, bt_t mode );
    int vui_reg_base_get( int dev, vmeaddr_t *regbase, bt_t *mode );
    int vui_transfer_mode_set( int dev, bt_t tm);
    int vui_transfer_mode_get( int dev, bt_t *tm );
    int vui_arb_mode_set( int dev, int arb );
    int vui_arb_mode_get( int dev, int *arb ); 
    int vui_bus_req_level_set( int dev, int brl );
    int vui_bus_req_level_get( int dev, int *brl );
    int vui_bus_req_mode_set( int dev, int brm );
    int vui_bus_req_mode_get( int dev, int *brm );
    int vui_bus_rel_mode_set( int dev, int brm );
    int vui_bus_rel_mode_get( int dev, int *brm );
    int vui_intr_ena( int dev, ioctl_irq_t *intr );
    int vui_intr_dis( int dev, ioctl_irq_t *intr ); 
    int vui_intr_generate( int dev, ioctl_irq_t *intr );
    int vui_board( int dev, char *name, short *rev ); 
    int vui_interface( int dev, char *name, short *rev );  
    int vui_abort_signal( int dev, int signal );
    int vui_abort_wait( int dev );   
    int vui_acfail_signal( int dev, int signal );
    int vui_acfail_wait( int dev );    
    int vui_sysfail_signal( int dev, int signal );
    int vui_sysfail_wait( int dev );
    int vui_sysfail_assert( int dev );
    int vui_sysfail_deassert( int dev ); 
    int vui_reset( int dev ); 
    void *vui_dma_malloc( int dev, size_t size );
    void *vui_fdma_malloc( int dev, ioctl_map_t *fdma );
    int vui_fdma_free( int dev, ioctl_map_t *fdma, caddr_t vaddr );
}

#endif

