/* KinokoAnalysisAction.hh */
/* Created by Enomoto Sanshiro on 24 June 2002. */
/* Last updated by Enomoto Sanshiro on 24 June 2002. */


#ifndef __KinokoAnalysisAction_hh__
#define __KinokoAnalysisAction_hh__


#include <string>
#include <vector>
#include "KinokoDataAnalyzer.hh"
#include "KinokoPlatform.hh"


class TKinokoAnalysisAction: public TKinokoDataAnalyzer {
  public:
    TKinokoAnalysisAction(void);
    virtual ~TKinokoAnalysisAction();
    virtual int ProcessDataPacket(void* DataPacket, TKinokoDataSource* DataSource = 0, TKinokoDataSection* DataSection = 0) throw(TKinokoException);
    virtual int ProcessTrailerPacket(void* Packet, TKinokoDataSource* DataSource = 0) throw(TKinokoException);
    virtual void Execute(void) = 0;
};


class TKinokoAnalysisInvokeAction: public TKinokoAnalysisAction {
  public:
    TKinokoAnalysisInvokeAction(TKinokoEventEmitter* EventEmitter, const std::string& EventName, const std::vector<std::string>& EventArgumentList);
    virtual ~TKinokoAnalysisInvokeAction();
    virtual void Execute(void);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    TKinokoEventEmitter* _EventEmitter;
    std::string _EventName;
    std::vector<std::string> _EventArgumentList;
};


#endif
