/* KinokoAnalysisScriptStatements.hh */
/* Created by Enomoto Sanshiro on 26 December 2000. */
/* Last updated by Enomoto Sanshiro on 23 September 2001. */


#ifndef __KinokoAnalysisScriptStatement_hh__
#define __KinokoAnalysisScriptStatement_hh__


#include <string>
#include <map>
#include "ParaParser.hh"
#include "KinokoAnalysisSequenceBuilder.hh"


class TKinokoAnalysisScriptAnalysisStatement: public TParaStatement {
  public:
    TKinokoAnalysisScriptAnalysisStatement(TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder);
    virtual ~TKinokoAnalysisScriptAnalysisStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoAnalysisSequenceBuilder* _AnalysisSequenceBuilder;
    std::string _DataSourceName;
    TParaExpression* _DataSourceNameExpression;
    TParaStatement* _Statement;
};


class TKinokoAnalysisScriptInvokeStatement: public TParaStatement {
  public:
    TKinokoAnalysisScriptInvokeStatement(TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder);
    virtual ~TKinokoAnalysisScriptInvokeStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoAnalysisSequenceBuilder* _AnalysisSequenceBuilder;
    std::string _EventName;
    std::vector<TParaExpression*> _EventArgumentExpressionList;
};


class TKinokoAnalysisScriptWhenStatement: public TParaStatement {
  public:
    TKinokoAnalysisScriptWhenStatement(TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder);
    virtual ~TKinokoAnalysisScriptWhenStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoAnalysisSequenceBuilder* _AnalysisSequenceBuilder;
    TParaExpression* _ConditionExpression;
    TParaStatement* _Statement;
};


#endif
