/* KinokoAnalysisSequenceBuilder.hh */
/* Created by Enomoto Sanshiro on 20 September 2001. */
/* Last updated by Enomoto Sanshiro on 16 June 2002. */


#ifndef __KinokoAnalysisSequenceBuilder_hh__
#define __KinokoAnalysisSequenceBuilder_hh__


#include <string>
#include <vector>
#include <map>
#include <deque>
#include "KinokoPlatform.hh"
#include "KinokoDataDistributor.hh"
#include "KinokoDataAnalyzer.hh"
#include "KinokoAnalysisSequence.hh"


class TKinokoAnalysisSequenceBuilder {
  public:
    TKinokoAnalysisSequenceBuilder(TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry);
    virtual ~TKinokoAnalysisSequenceBuilder();
    virtual TKinokoDataDistributor* DataDistributor(void);
    virtual std::vector<TKinokoAnalysisSequence*>& RootSequenceList(void);
    virtual TKinokoEventEmitter* EventEmitter(void);
    virtual TKinokoRegistry* Registry(void);
  public:
    virtual void OpenRootSequence(const std::string& DataSourceName);
    virtual void CloseRootSequence(void);
    virtual void OpenSubSequence(TKinokoAnalysisSequence* SubSequence) throw(TKinokoException);
    virtual void CloseSubSequence(void) throw(TKinokoException);
    virtual void AddAction(TKinokoDataAnalyzer* DataAnalyzer) throw(TKinokoException);
    virtual void AddSingleEventAction(TKinokoDataAnalyzer* DataAnalyzer) throw(TKinokoException);
  protected:
    virtual TKinokoAnalysisSequence* LookupRootSequence(const std::string& DataSourceName);
  protected:
    TKinokoDataDistributor* _DataDistributor;
    std::vector<TKinokoAnalysisSequence*> _RootSequenceList;
    std::map<std::string, TKinokoAnalysisSequence*> _RootSequenceTable;
    TKinokoEventEmitter* _EventEmitter;
    TKinokoRegistry* _Registry;
  private:
    TKinokoAnalysisSequence* _CurrentSequence;
    TKinokoAnalysisSequence* _CurrentSingleEventSequence;
    std::deque<TKinokoAnalysisSequence*> _AnalysisSequenceStack;
    std::deque<TKinokoAnalysisSequence*> _SingleEventAnalysisSequenceStack;
};


#endif
